/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.util;

import info.u_team.useful_railroads.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class VoxelShapeUtil {
    public static List<VoxelShape> createVoxelShapeFromVector(List<Pair<Vec3d, Vec3d>> list) {
        return list.stream().map(pair -> {
            Vec3d vec1 = (Vec3d)pair.getLeft();
            Vec3d vec2 = (Vec3d)pair.getRight();
            return Block.func_208617_a((double)vec1.func_82615_a(), (double)vec1.func_82617_b(), (double)vec1.func_82616_c(), (double)vec2.func_82615_a(), (double)vec2.func_82617_b(), (double)vec2.func_82616_c());
        }).collect(Collectors.toList());
    }

    public static Pair<Vec3d, Vec3d> createVectorPair(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Pair.of((Object)new Vec3d(x1, y1, z1), (Object)new Vec3d(x2, y2, z2));
    }

    public static List<Pair<Vec3d, Vec3d>> rotateAroundY(List<Pair<Vec3d, Vec3d>> list, double angle) {
        return list.stream().map(pair -> {
            Vec3d vec1 = MathUtil.rotateVectorAroundYCC(((Vec3d)pair.getLeft()).func_178786_a(8.0, 8.0, 8.0), angle).func_72441_c(8.0, 8.0, 8.0);
            Vec3d vec2 = MathUtil.rotateVectorAroundYCC(((Vec3d)pair.getRight()).func_178786_a(8.0, 8.0, 8.0), angle).func_72441_c(8.0, 8.0, 8.0);
            return Pair.of((Object)vec1, (Object)vec2);
        }).collect(Collectors.toList());
    }

    public static Map<Direction, List<Pair<Vec3d, Vec3d>>> getHorizontalRotations(List<Pair<Vec3d, Vec3d>> northShape) {
        HashMap<Direction, List<Pair<Vec3d, Vec3d>>> shapes = new HashMap<Direction, List<Pair<Vec3d, Vec3d>>>();
        shapes.put(Direction.NORTH, northShape);
        shapes.put(Direction.EAST, VoxelShapeUtil.rotateAroundY(northShape, -1.5707963267948966));
        shapes.put(Direction.SOUTH, VoxelShapeUtil.rotateAroundY(northShape, Math.PI));
        shapes.put(Direction.WEST, VoxelShapeUtil.rotateAroundY(northShape, 1.5707963267948966));
        return shapes;
    }
}

