/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import xyz.vsngamer.elevatorid.client.render.ElevatorBakedModel;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;

public class ElevatorTileEntity
extends TileEntity
implements INamedContainerProvider {
    private BlockState heldState;

    public ElevatorTileEntity() {
        super(Registry.ELEVATOR_TILE_ENTITY);
    }

    public void func_145839_a(CompoundNBT compound) {
        BlockState held_id = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("held_id"));
        this.heldState = held_id == Blocks.field_150350_a.func_176223_P() ? null : held_id;
        super.func_145839_a(compound);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.heldState != null) {
            compound.func_218657_a("held_id", (INBT)NBTUtil.func_190009_a((BlockState)this.heldState));
        }
        return super.func_189515_b(compound);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ElevatorBakedModel.HELD_STATE, (Object)this.heldState).build();
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        this.updateClient();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("screen.elevatorid.elevator", new Object[0]);
    }

    public Container createMenu(int id, @Nonnull PlayerInventory inv, @Nonnull PlayerEntity player) {
        return new ElevatorContainer(id, this.field_174879_c, player);
    }

    public void setHeldState(BlockState heldState) {
        this.heldState = heldState;
        this.updateServer();
    }

    public BlockState getHeldState() {
        return this.heldState;
    }

    private void updateServer() throws IllegalStateException {
        this.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            throw new IllegalStateException("Run this on the server");
        }
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.func_195044_w(), this.func_195044_w(), 3);
        this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
    }

    private void updateClient() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 1);
            this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
        }
    }

    public static TileEntityType<ElevatorTileEntity> getType(Block ... validBlocks) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(ElevatorTileEntity::new, (Block[])validBlocks).func_206865_a(null);
        type.setRegistryName("elevator_tile");
        return type;
    }
}

