/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client.render;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;

public class ElevatorBakedModel
extends BakedModelWrapper<IBakedModel> {
    public static final ModelProperty<BlockState> HELD_STATE = new ModelProperty();
    public static final EnumMap<Direction, IBakedModel> ARROW_VARIANTS = new EnumMap(Direction.class);

    public ElevatorBakedModel(IBakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState heldState;
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (layer == RenderType.func_228641_d_() && ((Boolean)state.func_177229_b((IProperty)ElevatorBlock.DIRECTIONAL)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)ElevatorBlock.SHOW_ARROW)).booleanValue()) {
            list.addAll(ARROW_VARIANTS.get(state.func_177229_b((IProperty)ElevatorBlock.field_185512_D)).getQuads(state, side, rand, extraData));
        }
        if ((heldState = (BlockState)extraData.getData(HELD_STATE)) != null) {
            if (RenderTypeLookup.canRenderInLayer((BlockState)heldState, (RenderType)layer)) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(heldState);
                list.addAll(model.getQuads(heldState, side, rand, extraData));
            }
            return list;
        }
        if (layer == RenderType.func_228639_c_()) {
            list.addAll(this.originalModel.getQuads(state, side, rand, extraData));
        }
        return list;
    }

    @Nonnull
    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        BlockState state = (BlockState)data.getData(HELD_STATE);
        if (state != null) {
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
            return model.getParticleTexture(data);
        }
        return super.getParticleTexture(data);
    }
}

