/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.gui;

import com.chaosthedude.endermail.EnderMail;
import com.chaosthedude.endermail.gui.StampTextField;
import com.chaosthedude.endermail.network.StampPackagePacket;
import com.chaosthedude.endermail.util.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StampScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("endermail:textures/gui/stamp.png");
    private Button confirmButton;
    private Button cancelButton;
    private StampTextField xTextField;
    private StampTextField yTextField;
    private StampTextField zTextField;
    private StampTextField lockerIDTextField;
    private World world;
    private PlayerEntity player;
    private BlockPos packagePos;
    private boolean errored;

    public StampScreen(World world, PlayerEntity player, BlockPos packagePos) {
        super((ITextComponent)new StringTextComponent(""));
        this.world = world;
        this.player = player;
        this.packagePos = packagePos;
    }

    public void init() {
        this.setupTextFields();
        this.setupButtons();
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int xSize = 178;
        int ySize = 222;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - xSize) / 2;
        int j = (this.height - ySize) / 2;
        RenderUtils.drawTexturedModalRect(i, j, 0, 0, xSize, ySize);
        if (this.errored) {
            RenderUtils.drawCenteredStringWithoutShadow(I18n.func_135052_a((String)"string.endermail.error", (Object[])new Object[0]), this.width / 2, this.height - 65, 0xAAAAAA);
        }
        RenderUtils.drawCenteredStringWithoutShadow(I18n.func_135052_a((String)"string.endermail.deliveryLocation", (Object[])new Object[0]), this.width / 2, this.height / 2 - 42, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow("X", this.width / 2 - 45, this.height / 2 - 5, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow("Y", this.width / 2 + 0, this.height / 2 - 5, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow("Z", this.width / 2 + 45, this.height / 2 - 5, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow(I18n.func_135052_a((String)"string.endermail.lockerID", (Object[])new Object[0]), this.width / 2, this.height / 2 + 13, 0xAAAAAA);
        this.lockerIDTextField.render(mouseX, mouseY, partialTicks);
        this.xTextField.render(mouseX, mouseY, partialTicks);
        this.yTextField.render(mouseX, mouseY, partialTicks);
        this.zTextField.render(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    public void tick() {
        super.tick();
        this.lockerIDTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.confirmButton.active = !this.lockerIDTextField.func_146179_b().isEmpty() && this.xTextField.func_146179_b().isEmpty() && this.yTextField.func_146179_b().isEmpty() && this.zTextField.func_146179_b().isEmpty() || StampScreen.isNumeric(this.xTextField.func_146179_b()) && (this.yTextField.func_146179_b().isEmpty() || StampScreen.isNumeric(this.yTextField.func_146179_b())) && StampScreen.isNumeric(this.zTextField.func_146179_b());
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private void setupButtons() {
        this.buttons.clear();
        this.cancelButton = (Button)this.addButton((Widget)new Button(20, this.height - 40, 80, 20, I18n.func_135052_a((String)"string.endermail.cancel", (Object[])new Object[0]), onPress -> this.minecraft.func_147108_a(null)));
        this.confirmButton = (Button)this.addButton((Widget)new Button(this.width - 100, this.height - 40, 80, 20, I18n.func_135052_a((String)"string.endermail.confirm", (Object[])new Object[0]), onPress -> {
            try {
                String lockerID = this.lockerIDTextField.func_146179_b();
                int x = -1;
                int y = -1;
                int z = -1;
                if (lockerID.isEmpty() || !this.xTextField.func_146179_b().isEmpty() && !this.yTextField.func_146179_b().isEmpty() && !this.zTextField.func_146179_b().isEmpty()) {
                    x = Integer.valueOf(this.xTextField.func_146179_b());
                    if (!this.yTextField.func_146179_b().isEmpty()) {
                        y = Integer.valueOf(this.yTextField.func_146179_b());
                    }
                    z = Integer.valueOf(this.zTextField.func_146179_b());
                }
                BlockPos deliveryPos = new BlockPos(x, y, z);
                EnderMail.network.sendToServer((Object)new StampPackagePacket(this.packagePos, deliveryPos, lockerID));
                this.minecraft.func_147108_a(null);
            }
            catch (NumberFormatException e) {
                this.errored = true;
            }
        }));
        this.confirmButton.active = false;
    }

    private void setupTextFields() {
        this.children.clear();
        this.xTextField = new StampTextField(this.font, this.width / 2 - 65, this.height / 2 - 30, 40, 20, "");
        this.yTextField = new StampTextField(this.font, this.width / 2 - 20, this.height / 2 - 30, 40, 20, "");
        this.zTextField = new StampTextField(this.font, this.width / 2 + 25, this.height / 2 - 30, 40, 20, "");
        this.lockerIDTextField = new StampTextField(this.font, this.width / 2 - 65, this.height / 2 + 25, 130, 20, "");
        this.func_212928_a((IGuiEventListener)this.xTextField);
        this.xTextField.func_146195_b(true);
        this.children.add(this.xTextField);
        this.children.add(this.yTextField);
        this.children.add(this.zTextField);
        this.children.add(this.lockerIDTextField);
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(s.charAt(i)) || i == 0 && size > 1 && s.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }
}

