/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.blocks.te;

import com.chaosthedude.endermail.gui.container.PackageContainer;
import com.chaosthedude.endermail.registry.EnderMailBlocks;
import com.chaosthedude.endermail.registry.EnderMailItems;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PackageTileEntity
extends TileEntity
implements IInventory,
INamedContainerProvider {
    public static final String NAME = "package";
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private int deliveryX = -1;
    private int deliveryY = -1;
    private int deliveryZ = -1;
    private String lockerID = "";
    private boolean hasDeliveryLocation = false;
    private boolean hasLockerID;
    protected ITextComponent customName;

    public PackageTileEntity() {
        super(EnderMailBlocks.PACKAGE_TE_TYPE);
    }

    public PackageTileEntity(NonNullList<ItemStack> contents) {
        this();
        this.contents = contents;
    }

    public int func_70302_i_() {
        return 5;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.contents) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.contents);
        this.deliveryX = compound.func_74762_e("DeliveryX");
        this.deliveryY = compound.func_74762_e("DeliveryY");
        this.deliveryZ = compound.func_74762_e("DeliveryZ");
        this.lockerID = compound.func_74779_i("LockerID");
        this.hasDeliveryLocation = compound.func_74767_n("HasDeliveryLocation");
        this.hasLockerID = compound.func_74767_n("HasLockerID");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.contents);
        compound.func_74768_a("DeliveryX", this.deliveryX);
        compound.func_74768_a("DeliveryY", this.deliveryY);
        compound.func_74768_a("DeliveryZ", this.deliveryZ);
        compound.func_74778_a("LockerID", this.lockerID);
        compound.func_74757_a("HasDeliveryLocation", this.hasDeliveryLocation);
        compound.func_74757_a("HasLockerID", this.hasLockerID);
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return compound;
    }

    public CompoundNBT writeItems(CompoundNBT compound) {
        if (!this.contents.isEmpty()) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.contents);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.contents, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.contents.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.contents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() != EnderMailItems.PACKAGE;
    }

    public void func_174888_l() {
        this.contents.clear();
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new PackageContainer(windowId, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : new TranslationTextComponent("block.endermail.package", new Object[0]);
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public void setDeliveryPos(BlockPos pos) {
        this.hasDeliveryLocation = true;
        this.deliveryX = pos.func_177958_n();
        this.deliveryY = pos.func_177956_o();
        this.deliveryZ = pos.func_177952_p();
    }

    public void setLockerID(String lockerID) {
        this.hasLockerID = true;
        this.lockerID = lockerID;
    }

    public String getLockerID() {
        if (this.hasLockerID) {
            return this.lockerID;
        }
        return null;
    }

    public BlockPos getDeliveryPos() {
        if (this.hasDeliveryLocation) {
            return new BlockPos(this.deliveryX, this.deliveryY, this.deliveryZ);
        }
        return null;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.getString().isEmpty();
    }
}

