/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.MathUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import java.util.List;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class ScrollBar
extends Widget {
    public final Plane plane;
    private int scrollBarSize;
    private double value = 0.0;
    private double scrollStep = 20.0;
    private double grab = -10000.0;
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private boolean canAlwaysScroll = false;
    private boolean canAlwaysScrollPlane = true;

    public ScrollBar(Panel parent, Plane p, int ss) {
        super(parent);
        this.plane = p;
        this.scrollBarSize = Math.max(ss, 0);
    }

    public void setCanAlwaysScroll(boolean v) {
        this.canAlwaysScroll = v;
    }

    public void setCanAlwaysScrollPlane(boolean v) {
        this.canAlwaysScrollPlane = v;
    }

    public void setMinValue(double min) {
        this.minValue = min;
        this.setValue(this.getValue());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double max) {
        this.maxValue = max;
        this.setValue(this.getValue());
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setScrollStep(double s) {
        this.scrollStep = Math.max(0.0, s);
    }

    public int getScrollBarSize() {
        return this.scrollBarSize;
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            this.grab = this.plane.isVertical ? (double)this.getMouseY() - ((double)this.getY() + this.getMappedValue(this.height - this.getScrollBarSize())) : (double)this.getMouseX() - ((double)this.getX() + this.getMappedValue(this.width - this.getScrollBarSize()));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double scroll) {
        if (scroll != 0.0 && this.canMouseScrollPlane() && this.canMouseScroll()) {
            this.setValue(this.getValue() - this.getScrollStep() * scroll);
            return true;
        }
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.showValueOnMouseOver()) {
            String t = this.getTitle();
            list.add(t.isEmpty() ? Double.toString(this.getValue()) : t + ": " + this.getValue());
        }
        if (Theme.renderDebugBoxes) {
            list.add(TextFormatting.DARK_GRAY + "Size: " + this.getScrollBarSize());
            list.add(TextFormatting.DARK_GRAY + "Max: " + this.getMaxValue());
            list.add(TextFormatting.DARK_GRAY + "Value: " + this.getValue());
        }
    }

    public boolean showValueOnMouseOver() {
        return false;
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        int scrollBarSize = this.getScrollBarSize();
        if (scrollBarSize > 0) {
            double v = this.getValue();
            if (this.grab != -10000.0) {
                if (ScrollBar.isMouseButtonDown(MouseButton.LEFT)) {
                    v = this.plane.isVertical ? ((double)this.getMouseY() - ((double)y + this.grab)) * this.getMaxValue() / (double)(this.height - scrollBarSize) : ((double)this.getMouseX() - ((double)x + this.grab)) * this.getMaxValue() / (double)(this.width - scrollBarSize);
                } else {
                    this.grab = -10000.0;
                }
            }
            this.setValue(v);
        }
        this.drawBackground(theme, x, y, this.width, this.height);
        if (scrollBarSize > 0) {
            if (this.plane.isVertical) {
                this.drawScrollBar(theme, x, (int)((double)y + this.getMappedValue(this.height - scrollBarSize)), this.width, scrollBarSize);
            } else {
                this.drawScrollBar(theme, (int)((double)x + this.getMappedValue(this.width - scrollBarSize)), y, scrollBarSize, this.height);
            }
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBarBackground(x, y, w, h, this.getWidgetType());
    }

    public void drawScrollBar(Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBar(x, y, w, h, WidgetType.mouseOver(this.grab != -10000.0), this.plane.isVertical);
    }

    public void onMoved() {
    }

    public boolean canMouseScrollPlane() {
        return this.canAlwaysScrollPlane || ScrollBar.isShiftKeyDown() != this.plane.isVertical;
    }

    public boolean canMouseScroll() {
        return this.canAlwaysScroll || this.isMouseOver();
    }

    public void setValue(double v) {
        if (this.value != (v = MathHelper.func_151237_a((double)v, (double)this.getMinValue(), (double)this.getMaxValue()))) {
            this.value = v;
            this.onMoved();
        }
    }

    public double getValue() {
        return this.value;
    }

    public double getMappedValue(double max) {
        return MathUtils.map(this.getMinValue(), this.getMaxValue(), 0.0, max, this.value);
    }

    public double getScrollStep() {
        return this.scrollStep;
    }

    public static enum Plane {
        HORIZONTAL(false),
        VERTICAL(true);

        public final boolean isVertical;

        private Plane(boolean v) {
            this.isVertical = v;
        }
    }
}

