/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.KeyModifiers;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.IGuiWrapper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuiWrapper
extends Screen
implements IGuiWrapper {
    private GuiBase wrappedGui;
    private List<String> tempTextList = new ArrayList<String>();

    public GuiWrapper(GuiBase g) {
        super((ITextComponent)new StringTextComponent(g.getTitle()));
        this.wrappedGui = g;
    }

    public void init() {
        super.init();
        this.wrappedGui.itemRenderer = this.itemRenderer;
        this.wrappedGui.initGui();
    }

    public boolean isPauseScreen() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        this.wrappedGui.mousePressed(MouseButton.get(button));
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.mouseReleased(x, y, button);
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        this.wrappedGui.mouseScrolled(scroll);
        return super.mouseScrolled(x, y, scroll);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Object object;
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
        } else if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(false);
        } else if (ModList.get().isLoaded("jei") && (object = WrappedIngredient.unwrap(this.wrappedGui.getIngredientUnderMouse())) != null) {
            this.handleIngredientKey(key, object);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.charTyped(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(true);
        }
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        this.renderBackground();
        GuiHelper.setupDrawing();
        int x = this.wrappedGui.getX();
        int y = this.wrappedGui.getY();
        int w = this.wrappedGui.width;
        int h = this.wrappedGui.height;
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.draw(theme, x, y, w, h);
        this.wrappedGui.drawForeground(theme, x, y, w, h);
        if (this.wrappedGui.contextMenu != null) {
            this.wrappedGui.contextMenu.addMouseOverText(this.tempTextList);
        } else {
            this.wrappedGui.addMouseOverText(this.tempTextList);
        }
        if (this.tempTextList.isEmpty()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack && !((ItemStack)ingredient).func_190926_b()) {
                this.renderTooltip((ItemStack)ingredient, mouseX, mouseY);
            }
        } else {
            GuiUtils.drawHoveringText(this.tempTextList, (int)mouseX, (int)Math.max(mouseY, 18), (int)this.wrappedGui.getScreen().func_198107_o(), (int)this.wrappedGui.getScreen().func_198087_p(), (int)0, (FontRenderer)theme.getFont());
        }
        this.tempTextList.clear();
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(false);
        }
    }

    public void renderBackground() {
        if (this.wrappedGui.drawDefaultBackground()) {
            super.renderBackground();
        }
    }

    public void tick() {
        super.tick();
        this.wrappedGui.tick();
    }

    @Override
    public GuiBase getGui() {
        return this.wrappedGui;
    }
}

