/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.KeyModifiers;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.IGuiWrapper;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.WrappedIngredient;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuiContainerWrapper
extends ContainerScreen
implements IGuiWrapper {
    private GuiBase wrappedGui;
    private boolean drawSlots = true;
    private List<String> tempTextList = new ArrayList<String>();

    public GuiContainerWrapper(GuiBase g, Container c, PlayerInventory playerInventory, ITextComponent title) {
        super(c, playerInventory, title);
        this.wrappedGui = g;
    }

    public GuiContainerWrapper disableSlotDrawing() {
        this.drawSlots = false;
        return this;
    }

    public void init() {
        super.init();
        this.wrappedGui.initGui();
        this.field_147003_i = this.wrappedGui.getX();
        this.field_147009_r = this.wrappedGui.getY();
        this.field_146999_f = this.wrappedGui.width;
        this.field_147000_g = this.wrappedGui.height;
    }

    public boolean isPauseScreen() {
        return this.wrappedGui.doesGuiPauseGame();
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.wrappedGui.onBack();
            return true;
        }
        this.wrappedGui.mousePressed(MouseButton.get(button));
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseReleased(double x, double y, int button) {
        this.wrappedGui.updateMouseOver((int)x, (int)y);
        this.wrappedGui.mouseReleased(MouseButton.get(button));
        return super.mouseReleased(x, y, button);
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        this.wrappedGui.mouseScrolled(scroll);
        return super.mouseScrolled(x, y, scroll);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.wrappedGui.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.wrappedGui.onBack();
        } else if (this.wrappedGui.onClosedByKey(key)) {
            this.wrappedGui.closeGui(false);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.wrappedGui.keyReleased(key);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char keyChar, int modifiers) {
        if (this.wrappedGui.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.charTyped(keyChar, (int)keyChar);
    }

    protected void func_146976_a(float f, int mx, int my) {
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(true);
        }
        Theme theme = this.wrappedGui.getTheme();
        GuiHelper.setupDrawing();
        this.renderBackground();
        GuiHelper.setupDrawing();
        this.wrappedGui.draw(theme, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.drawSlots) {
            GuiHelper.setupDrawing();
            for (Slot slot : this.field_147002_h.field_75151_b) {
                theme.drawContainerSlot(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 16, 16);
            }
        }
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(false);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(true);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        GuiHelper.setupDrawing();
        Theme theme = this.wrappedGui.getTheme();
        this.wrappedGui.drawForeground(theme, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        if (this.wrappedGui.contextMenu != null) {
            this.wrappedGui.contextMenu.addMouseOverText(this.tempTextList);
        } else {
            this.wrappedGui.addMouseOverText(this.tempTextList);
        }
        if (this.tempTextList.isEmpty()) {
            Object ingredient;
            Object object = this.wrappedGui.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap(object)) instanceof ItemStack && !((ItemStack)ingredient).func_190926_b()) {
                this.renderTooltip((ItemStack)ingredient, mouseX, mouseY);
            }
        } else {
            GuiUtils.drawHoveringText(this.tempTextList, (int)mouseX, (int)Math.max(mouseY, 18), (int)this.wrappedGui.getScreen().func_198107_o(), (int)this.wrappedGui.getScreen().func_198087_p(), (int)0, (FontRenderer)theme.getFont());
        }
        this.tempTextList.clear();
        if (this.wrappedGui.contextMenu == null) {
            this.func_191948_b(mouseX, mouseY);
        }
        RenderSystem.popMatrix();
        if (this.wrappedGui.fixUnicode) {
            GuiHelper.setFixUnicode(false);
        }
    }

    public void renderBackground() {
        if (this.wrappedGui.drawDefaultBackground()) {
            super.renderBackground();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.wrappedGui.updateGui(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
    }

    public void tick() {
        super.tick();
        this.wrappedGui.tick();
    }

    @Override
    public GuiBase getGui() {
        return this.wrappedGui;
    }
}

