/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.widget;

import com.feed_the_beast.mods.ftbguilibrary.misc.GuiLoading;
import com.feed_the_beast.mods.ftbguilibrary.utils.BooleanConsumer;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenu;
import com.feed_the_beast.mods.ftbguilibrary.widget.ContextMenuItem;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiWrapper;
import com.feed_the_beast.mods.ftbguilibrary.widget.IOpenableGui;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.lwjgl.glfw.GLFW;

public abstract class GuiBase
extends Panel
implements IOpenableGui {
    private int mouseX;
    private int mouseY;
    private float partialTicks;
    private boolean refreshWidgets;
    private MainWindow screen;
    public boolean fixUnicode;
    private Screen prevScreen;
    public Panel contextMenu = null;
    public ItemRenderer itemRenderer;

    public GuiBase() {
        super(null);
        this.setSize(176, 166);
        this.setOnlyRenderWidgetsInside(false);
        this.setOnlyInteractWithWidgetsInside(false);
        this.prevScreen = Minecraft.func_71410_x().field_71462_r;
    }

    @Override
    public final GuiBase getGui() {
        return this;
    }

    @Override
    public void alignWidgets() {
    }

    public final void initGui() {
        this.screen = this.parent instanceof GuiBase ? this.parent.getScreen() : Minecraft.func_71410_x().func_228018_at_();
        if (this.onInit()) {
            super.refreshWidgets();
            this.fixUnicode = this.getScreen().func_198100_s() % 2.0 == 1.0;
            this.alignWidgets();
            this.onPostInit();
        }
    }

    public Theme getTheme() {
        return Theme.DEFAULT;
    }

    @Override
    public int getX() {
        return (this.getScreen().func_198107_o() - this.width) / 2;
    }

    @Override
    public int getY() {
        return (this.getScreen().func_198087_p() - this.height) / 2;
    }

    @Override
    public void setScrollX(double scroll) {
    }

    @Override
    public void setScrollY(double scroll) {
    }

    @Override
    public double getScrollX() {
        return 0.0;
    }

    @Override
    public double getScrollY() {
        return 0.0;
    }

    public boolean onInit() {
        return true;
    }

    protected boolean setFullscreen() {
        this.setWidth(this.screen.func_198107_o());
        this.setHeight(this.screen.func_198087_p());
        return true;
    }

    public void onPostInit() {
    }

    @Nullable
    public Screen getPrevScreen() {
        if (this.prevScreen instanceof GuiWrapper && ((GuiWrapper)this.prevScreen).getGui() instanceof GuiLoading) {
            return ((GuiWrapper)this.prevScreen).getGui().getPrevScreen();
        }
        if (this.prevScreen instanceof ChatScreen) {
            return null;
        }
        return this.prevScreen;
    }

    @Override
    public final void closeGui(boolean openPrevScreen) {
        double mx = Minecraft.func_71410_x().field_71417_B.func_198024_e();
        double my = Minecraft.func_71410_x().field_71417_B.func_198026_f();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            mc.field_71439_g.func_71053_j();
            if (mc.field_71462_r == null) {
                mc.func_213228_a(true);
            }
        }
        if (openPrevScreen) {
            mc.func_147108_a(this.getPrevScreen());
            GLFW.glfwSetCursorPos((long)this.getScreen().func_198092_i(), (double)my, (double)my);
        }
        this.onClosed();
    }

    public boolean onClosedByKey(Key key) {
        return key.escOrInventory();
    }

    public void onBack() {
        this.closeGui(true);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.mouseX = mx;
        this.mouseY = my;
        this.partialTicks = pt;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.refreshWidgets = false;
        }
        this.posX = this.getX();
        this.posY = this.getY();
        if (this.contextMenu != null) {
            if (this.contextMenu instanceof GuiBase) {
                ((GuiBase)this.contextMenu).updateGui(mx, my, pt);
            } else {
                this.contextMenu.updateMouseOver(this.mouseX, this.mouseY);
            }
        }
        this.updateMouseOver(this.mouseX, this.mouseY);
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
        this.setOffset(true);
        if (this.contextMenu != null) {
            this.contextMenu.updateMouseOver(mouseX, mouseY);
        } else {
            for (Widget widget : this.widgets) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.setOffset(false);
    }

    @Override
    public final void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
    }

    @Override
    public void openContextMenu(@Nullable Panel panel) {
        int px = 0;
        int py = 0;
        if (this.contextMenu != null) {
            px = this.contextMenu.posX;
            py = this.contextMenu.posY;
            this.contextMenu.onClosed();
            this.widgets.remove(this.contextMenu);
        }
        if (panel == null) {
            this.contextMenu = null;
            return;
        }
        int x = this.getX();
        int y = this.getY();
        if (this.contextMenu == null) {
            px = this.getMouseX() - x;
            py = this.getMouseY() - y;
        }
        this.contextMenu = panel;
        this.contextMenu.parent = this;
        this.widgets.add(this.contextMenu);
        this.contextMenu.refreshWidgets();
        px = Math.min(px, this.screen.func_198107_o() - this.contextMenu.width - x) - 3;
        py = Math.min(py, this.screen.func_198087_p() - this.contextMenu.height - y) - 3;
        this.contextMenu.setPos(px, py);
        if (this.contextMenu instanceof GuiBase) {
            ((GuiBase)this.contextMenu).initGui();
        }
    }

    public ContextMenu openContextMenu(List<ContextMenuItem> menu) {
        ContextMenu contextMenu = new ContextMenu(this, menu);
        this.openContextMenu(contextMenu);
        return contextMenu;
    }

    @Override
    public void closeContextMenu() {
        this.openContextMenu((Panel)null);
        this.onInit();
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.closeContextMenu();
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawGui(x, y, w, h, WidgetType.NORMAL);
    }

    public boolean drawDefaultBackground() {
        return true;
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (button == MouseButton.BACK) {
            this.closeGui(true);
        }
        return super.mousePressed(button);
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && key.is(66)) {
            Theme.renderDebugBoxes = !Theme.renderDebugBoxes;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return this.contextMenu == null;
    }

    public Screen getWrapper() {
        return new GuiWrapper(this);
    }

    @Override
    public final void openGui() {
        this.openContextMenu((Panel)null);
        Minecraft.func_71410_x().func_147108_a(this.getWrapper());
    }

    @Override
    public final MainWindow getScreen() {
        if (this.screen == null) {
            return this.parent.getScreen();
        }
        return this.screen;
    }

    @Override
    public final int getMouseX() {
        return this.mouseX;
    }

    @Override
    public final int getMouseY() {
        return this.mouseY;
    }

    @Override
    public final float getPartialTicks() {
        return this.partialTicks;
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget widget) {
        if (widget == this) {
            return this.isMouseOver(this.getX(), this.getY(), this.width, this.height);
        }
        if (this.isMouseOver(widget.getX(), widget.getY(), widget.width, widget.height)) {
            boolean offset = widget.parent.isOffset();
            widget.parent.setOffset(false);
            boolean b = this.isMouseOver(widget.parent);
            widget.parent.setOffset(offset);
            return b;
        }
        return false;
    }

    @Override
    public boolean handleClick(String scheme, String path) {
        return ClientUtils.handleClick(scheme, path);
    }

    public void openYesNoFull(ITextComponent title, ITextComponent desc, BooleanConsumer callback) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmScreen(result -> {
            this.openGui();
            callback.accept(result);
            this.refreshWidgets();
        }, title, desc));
    }

    public final void openYesNo(ITextComponent title, ITextComponent desc, Runnable callback) {
        this.openYesNoFull(title, desc, result -> {
            if (result) {
                callback.run();
            }
        });
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final ClickEvent clickEvent;
        public final HoverEvent hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, Style s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.func_150235_h();
            this.hoverEvent = s.func_150210_i();
            this.insertion = s.func_179986_j();
        }
    }
}

