/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.config.gui;

import com.feed_the_beast.mods.ftbguilibrary.config.ConfigCallback;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigInt;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigItemStack;
import com.feed_the_beast.mods.ftbguilibrary.config.ConfigNBT;
import com.feed_the_beast.mods.ftbguilibrary.config.gui.GuiEditConfigFromString;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ItemIcon;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.BlankPanel;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiHelper;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.PanelScrollBar;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleTextButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.TextBox;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetLayout;
import com.feed_the_beast.mods.ftbguilibrary.widget.WidgetType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;

public class GuiSelectItemStack
extends GuiBase {
    private static boolean allItems = true;
    private final ConfigItemStack config;
    private final ConfigCallback callback;
    private ItemStack current;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final Panel panelStacks;
    private final PanelScrollBar scrollBar;
    private TextBox searchBox;
    private final Panel tabs;
    private ThreadItemList threadItemList;
    private List<Widget> newStackWidgets;
    public long update = Long.MAX_VALUE;

    public GuiSelectItemStack(ConfigItemStack c, ConfigCallback cb) {
        this.setSize(211, 150);
        this.config = c;
        this.callback = cb;
        this.current = ((ItemStack)this.config.value).func_190926_b() ? ItemStack.field_190927_a : ((ItemStack)this.config.value).func_77946_l();
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                GuiSelectItemStack.this.callback.save(false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                this.playClickSound();
                GuiSelectItemStack.this.config.setCurrentValue(GuiSelectItemStack.this.current);
                GuiSelectItemStack.this.callback.save(true);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.panelStacks = new BlankPanel(this){

            @Override
            public void addWidgets() {
                GuiSelectItemStack.this.update = System.currentTimeMillis() + 200L;
            }

            @Override
            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(x, y, w, h);
            }
        };
        this.panelStacks.setPosAndSize(9, 24, 172, 96);
        this.scrollBar = new PanelScrollBar(this, this.panelStacks);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20.0);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                GuiSelectItemStack.this.panelStacks.refreshWidgets();
            }
        };
        this.searchBox.setPosAndSize(8, 7, this.width - 16, 12);
        this.searchBox.ghostText = I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]);
        this.searchBox.setFocused(true);
        this.tabs = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new ButtonSwitchMode(this));
                this.add(new ButtonEditData(this));
                if (!((GuiSelectItemStack)GuiSelectItemStack.this).config.singleItemOnly) {
                    this.add(new ButtonCount(this));
                }
                this.add(new ButtonNBT(this));
                this.add(new ButtonCaps(this));
            }

            @Override
            public void alignWidgets() {
                for (Widget widget : this.widgets) {
                    widget.setSize(20, 20);
                }
                this.setHeight(this.align(WidgetLayout.VERTICAL));
            }
        };
        this.tabs.setPosAndSize(-19, 8, 20, 0);
        this.threadItemList = new ThreadItemList();
        this.threadItemList.start();
    }

    @Override
    public void addWidgets() {
        this.add(this.tabs);
        this.add(this.panelStacks);
        this.add(this.scrollBar);
        this.add(this.searchBox);
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.stopSearch();
    }

    private void stopSearch() {
        if (this.threadItemList != null) {
            try {
                this.threadItemList.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.threadItemList = null;
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return false;
        }
        return false;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        long now;
        super.drawBackground(theme, x, y, w, h);
        if (this.newStackWidgets != null) {
            this.panelStacks.widgets.clear();
            this.panelStacks.addAll(this.newStackWidgets);
            this.scrollBar.setPosAndSize(this.panelStacks.posX + this.panelStacks.width + 6, this.panelStacks.posY - 1, 16, this.panelStacks.height + 2);
            this.scrollBar.setValue(0.0);
            this.scrollBar.setMaxValue(1 + MathHelper.func_76123_f((float)((float)this.panelStacks.widgets.size() / 9.0f)) * 19);
            this.newStackWidgets = null;
        }
        if ((now = System.currentTimeMillis()) >= this.update) {
            this.update = Long.MAX_VALUE;
            this.stopSearch();
            this.threadItemList = new ThreadItemList();
            this.threadItemList.start();
        }
    }

    @Override
    public boolean doesGuiPauseGame() {
        Screen screen = this.getPrevScreen();
        return screen != null && screen.isPauseScreen();
    }

    private class ThreadItemList
    extends Thread {
        private final String search;

        public ThreadItemList() {
            super("Item Search Thread");
            this.setDaemon(true);
            this.search = GuiSelectItemStack.this.searchBox.getText().toLowerCase();
        }

        @Override
        public void run() {
            ArrayList<ItemStackButton> widgets = new ArrayList<ItemStackButton>();
            NonNullList list = NonNullList.func_191196_a();
            if (allItems) {
                for (Item item : ForgeRegistries.ITEMS) {
                    item.func_150895_a(ItemGroup.field_78027_g, list);
                }
                list.add((Object)new ItemStack((IItemProvider)Blocks.field_150483_bI));
                list.add((Object)new ItemStack((IItemProvider)Blocks.field_180401_cv));
                list.add((Object)new ItemStack((IItemProvider)Blocks.field_189881_dj));
            } else {
                for (int i = 0; i < Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    list.add((Object)stack);
                }
            }
            String mod = "";
            if (this.search.startsWith("@")) {
                mod = this.search.substring(1);
            }
            ItemStackButton button = new ItemStackButton(GuiSelectItemStack.this.panelStacks, ItemStack.field_190927_a);
            if (((GuiSelectItemStack)GuiSelectItemStack.this).config.allowEmpty && button.shouldAdd(this.search, mod)) {
                widgets.add(new ItemStackButton(GuiSelectItemStack.this.panelStacks, ItemStack.field_190927_a));
            }
            for (ItemStack stack : list) {
                if (stack.func_190926_b() || !(button = new ItemStackButton(GuiSelectItemStack.this.panelStacks, stack)).shouldAdd(this.search, mod)) continue;
                widgets.add(button);
            }
            for (int i = 0; i < widgets.size(); ++i) {
                ((Widget)widgets.get(i)).setPos(1 + i % 9 * 19, 1 + i / 9 * 19);
            }
            GuiSelectItemStack.this.newStackWidgets = widgets;
        }
    }

    private class ButtonCaps
    extends ButtonStackConfig {
        public ButtonCaps(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftbguilibrary.select_item.caps", (Object[])new Object[0]), ItemIcon.getItemIcon(Blocks.field_150467_bQ));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            CompoundNBT nbt = GuiSelectItemStack.this.current.serializeNBT();
            ConfigNBT c = new ConfigNBT();
            GuiEditConfigFromString.open(c, (CompoundNBT)nbt.func_74781_a("ForgeCaps"), (CompoundNBT)((ItemStack)((GuiSelectItemStack)GuiSelectItemStack.this).config.defaultValue).serializeNBT().func_74781_a("ForgeCaps"), accepted -> {
                if (accepted) {
                    if (c.value == null || ((CompoundNBT)c.value).isEmpty()) {
                        nbt.func_82580_o("ForgeCaps");
                    } else {
                        nbt.func_218657_a("ForgeCaps", (INBT)c.value);
                    }
                    GuiSelectItemStack.this.current = ItemStack.func_199557_a((CompoundNBT)nbt);
                }
                GuiSelectItemStack.this.run();
            });
        }
    }

    private class ButtonNBT
    extends ButtonStackConfig {
        public ButtonNBT(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftbguilibrary.select_item.nbt", (Object[])new Object[0]), ItemIcon.getItemIcon(Items.field_151057_cb));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigNBT c = new ConfigNBT();
            GuiEditConfigFromString.open(c, GuiSelectItemStack.this.current.func_77978_p(), ((ItemStack)((GuiSelectItemStack)GuiSelectItemStack.this).config.defaultValue).func_77978_p(), accepted -> {
                if (accepted) {
                    GuiSelectItemStack.this.current.func_77982_d((CompoundNBT)c.value);
                }
                this.run();
            });
        }
    }

    private class ButtonCount
    extends ButtonStackConfig {
        public ButtonCount(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftbguilibrary.select_item.count", (Object[])new Object[0]), ItemIcon.getItemIcon(Items.field_151121_aF));
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigInt c = new ConfigInt(0, GuiSelectItemStack.this.current.func_77976_d());
            GuiEditConfigFromString.open(c, GuiSelectItemStack.this.current.func_190916_E(), ((ItemStack)((GuiSelectItemStack)GuiSelectItemStack.this).config.defaultValue).func_190916_E(), accepted -> {
                if (accepted) {
                    GuiSelectItemStack.this.current.func_190920_e(((Integer)c.value).intValue());
                }
                this.run();
            });
        }
    }

    private class ButtonEditData
    extends Button {
        public ButtonEditData(Panel panel) {
            super(panel, "", GuiIcons.BUG);
        }

        @Override
        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            GuiHelper.drawItem(GuiSelectItemStack.this.current, x, y, (double)w / 16.0, (double)h / 16.0, true);
        }

        @Override
        public String getTitle() {
            return GuiSelectItemStack.this.current.func_200301_q().func_150254_d();
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            ConfigNBT c = new ConfigNBT();
            GuiEditConfigFromString.open(c, GuiSelectItemStack.this.current.serializeNBT(), ((ItemStack)((GuiSelectItemStack)GuiSelectItemStack.this).config.defaultValue).serializeNBT(), accepted -> {
                if (accepted) {
                    GuiSelectItemStack.this.current = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)c.value));
                }
                this.run();
            });
        }
    }

    private abstract class ButtonStackConfig
    extends Button {
        public ButtonStackConfig(Panel panel, String title, Icon icon) {
            super(panel, title, icon);
        }

        @Override
        public WidgetType getWidgetType() {
            return GuiSelectItemStack.this.current.func_190926_b() ? WidgetType.DISABLED : super.getWidgetType();
        }
    }

    private class ButtonSwitchMode
    extends Button {
        private final Icon ICON_ALL;
        private final Icon ICON_INV;

        public ButtonSwitchMode(Panel panel) {
            super(panel);
            this.ICON_ALL = ItemIcon.getItemIcon(Items.field_151111_aL);
            this.ICON_INV = ItemIcon.getItemIcon(Blocks.field_150486_ae);
        }

        @Override
        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            (allItems ? this.ICON_ALL : this.ICON_INV).draw(x, y, w, h);
        }

        @Override
        public String getTitle() {
            return I18n.func_135052_a((String)"ftbguilibrary.select_item.list_mode", (Object[])new Object[]{TextFormatting.GRAY + (allItems ? I18n.func_135052_a((String)"ftbguilibrary.select_item.list_mode.all", (Object[])new Object[0]) : I18n.func_135052_a((String)"ftbguilibrary.select_item.list_mode.inv", (Object[])new Object[0]))}) + TextFormatting.DARK_GRAY + " [" + (((GuiSelectItemStack)GuiSelectItemStack.this).panelStacks.widgets.size() - 1) + "]";
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            allItems = !allItems;
            GuiSelectItemStack.this.panelStacks.refreshWidgets();
        }
    }

    private class ItemStackButton
    extends Button {
        private final ItemStack stack;

        private ItemStackButton(Panel panel, ItemStack is) {
            super(panel, "", GuiIcons.BARRIER);
            this.setSize(18, 18);
            this.stack = is;
            this.title = null;
            this.icon = ItemIcon.getItemIcon(is);
        }

        public boolean shouldAdd(String search, String mod) {
            if (search.isEmpty()) {
                return true;
            }
            if (!mod.isEmpty()) {
                return this.stack.func_77973_b().getRegistryName().func_110624_b().contains(mod);
            }
            return this.stack.func_200301_q().getString().toLowerCase().contains(search);
        }

        @Override
        public String getTitle() {
            if (this.title == null) {
                this.title = this.stack.func_200301_q().func_150254_d();
            }
            return this.title;
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public WidgetType getWidgetType() {
            return this.stack.func_77973_b() == GuiSelectItemStack.this.current.func_77973_b() && Objects.equals(this.stack.func_77978_p(), GuiSelectItemStack.this.current.func_77978_p()) ? WidgetType.MOUSE_OVER : super.getWidgetType();
        }

        @Override
        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            (this.getWidgetType() == WidgetType.MOUSE_OVER ? Color4I.LIGHT_GREEN.withAlpha(70) : Color4I.BLACK.withAlpha(50)).draw(x, y, w, h);
        }

        @Override
        public void onClicked(MouseButton button) {
            this.playClickSound();
            GuiSelectItemStack.this.current = this.stack.func_77946_l();
        }
    }
}

