/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.routing.instruction;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import xyz.brassgoggledcoders.transport.api.routing.instruction.Routing;

public class TimeRouting
extends Routing {
    private static final Predicate<String> TIME_PATTERNS = Pattern.compile("\\d{1,2}:\\d{1,2}").asPredicate();
    private static final Map<String, Integer> TIMES = TimeRouting.createTimeMap();
    private final int startTime;
    private final int endTime;

    public TimeRouting(int startTime, int endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public boolean matches(@Nonnull AbstractMinecartEntity minecartEntity) {
        long dayTime = minecartEntity.func_130014_f_().func_72820_D() % 24000L;
        return dayTime > (long)this.startTime && dayTime < (long)this.endTime;
    }

    @Nonnull
    public static Either<String, Routing> create(List<String> inputs) {
        int startTime = -1;
        int endTime = 24000;
        if (inputs.size() >= 1) {
            Either<String, Integer> parsedStart = TimeRouting.parseTimeString(inputs.get(0));
            if (parsedStart.left().isPresent()) {
                return parsedStart.mapBoth(error -> error, value -> null);
            }
            if (parsedStart.right().isPresent()) {
                startTime = (Integer)parsedStart.right().get();
            }
        }
        if (inputs.size() > 1) {
            Either<String, Integer> parsedEnd = TimeRouting.parseTimeString(inputs.get(1));
            if (parsedEnd.left().isPresent()) {
                return parsedEnd.mapBoth(error -> error, value -> null);
            }
            if (parsedEnd.right().isPresent()) {
                endTime = (Integer)parsedEnd.right().get();
            }
        }
        if (startTime >= 0 && endTime > 0 && endTime > startTime) {
            return Either.right((Object)new TimeRouting(startTime, endTime));
        }
        return Either.left((Object)("Found invalid times: " + startTime + " & " + endTime));
    }

    public static Either<String, Integer> parseTimeString(String timeString) {
        Integer time = TIMES.get((timeString = timeString.trim()).toLowerCase(Locale.ENGLISH));
        if (time == null) {
            if (TIME_PATTERNS.test(timeString)) {
                String[] times = timeString.split(":");
                Either<String, Integer> hour = TimeRouting.parseGroup(times[0]);
                Either<String, Integer> minute = TimeRouting.parseGroup(times[1]);
                if (hour.left().isPresent()) {
                    return hour;
                }
                if (minute.left().isPresent()) {
                    return minute;
                }
                int totalHour = hour.right().map(value -> value % 24).orElse(0) * 1000 - 6000;
                if (totalHour < 0) {
                    totalHour += 24000;
                }
                int totalMinute = Math.round((float)minute.right().map(value -> value % 60).orElse(0).intValue() * 16.6f);
                return Either.right((Object)(totalHour + totalMinute));
            }
        } else {
            return Either.right((Object)time);
        }
        return Either.left((Object)("Couldn't convert " + timeString + " to time"));
    }

    private static Either<String, Integer> parseGroup(String group) {
        try {
            return Either.right((Object)Integer.parseInt(group));
        }
        catch (ClassCastException exception) {
            return Either.left((Object)(group + " is not a number"));
        }
    }

    private static Map<String, Integer> createTimeMap() {
        HashMap times = Maps.newHashMap();
        times.put("day", 1000);
        times.put("noon", 6000);
        times.put("night", 13000);
        times.put("midnight", 18000);
        return times;
    }
}

