/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.power.IPowerBase;
import com.bluepowermod.block.power.BlockBattery;
import com.bluepowermod.helper.EnergyHelper;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileBattery
extends TileMachineBase {
    private final int MAX_ENERGY = 3200;
    private final BlutricityStorage storage = new BlutricityStorage(3200.0, 100.0);
    private LazyOptional<IPowerBase> blutricityCap;

    public TileBattery() {
        super(BPTileEntityType.BATTERY);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.storage.resetCurrent();
            for (Direction facing : Direction.values()) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null) continue;
                tile.getCapability(CapabilityBlutricity.BLUTRICITY_CAPABILITY, facing.func_176734_d()).ifPresent(exStorage -> EnergyHelper.balancePower(exStorage, this.storage));
            }
            double energy = this.storage.getEnergy();
            int level = (int)(energy / 3200.0 * 6.0);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if ((Integer)state.func_177229_b((IProperty)BlockBattery.LEVEL) != level) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((IProperty)BlockBattery.LEVEL, (Comparable)Integer.valueOf(level)));
                this.markForRenderUpdate();
                this.func_70296_d();
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }

    @Override
    protected void readFromPacketNBT(CompoundNBT tCompound) {
        super.readFromPacketNBT(tCompound);
        if (tCompound.func_74764_b("energy")) {
            INBT nbtstorage = tCompound.func_74781_a("energy");
            CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null, nbtstorage);
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundNBT tCompound) {
        super.writeToPacketNBT(tCompound);
        INBT nbtstorage = CapabilityBlutricity.BLUTRICITY_CAPABILITY.getStorage().writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, (Object)this.storage, null);
        tCompound.func_218657_a("energy", nbtstorage);
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

