/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.container.ContainerProjectTable;
import com.bluepowermod.tile.BPTileEntityType;
import com.bluepowermod.tile.TileBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileProjectTable
extends TileBase
implements IInventory,
INamedContainerProvider {
    public static final int SLOTS = 28;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
    protected NonNullList<ItemStack> craftingGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);

    public TileProjectTable() {
        super(BPTileEntityType.PROJECT_TABLE);
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            drops.add((Object)stack);
        }
        for (ItemStack stack : this.craftingGrid) {
            if (stack.func_190926_b()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT tagCompound;
        int currentIndex;
        super.func_189515_b(tag);
        ListNBT tagList = new ListNBT();
        for (currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            tagCompound = new CompoundNBT();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).func_77955_b(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.func_218657_a("Items", (INBT)tagList);
        tagList = new ListNBT();
        for (currentIndex = 0; currentIndex < this.craftingGrid.size(); ++currentIndex) {
            tagCompound = new CompoundNBT();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            ((ItemStack)this.craftingGrid.get(currentIndex)).func_77955_b(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.func_218657_a("CraftingGrid", (INBT)tagList);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        byte slot;
        CompoundNBT tagCompound;
        int i;
        super.func_145839_a(tag);
        ListNBT tagList = tag.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)19, (Object)ItemStack.field_190927_a);
        for (i = 0; i < tagList.size(); ++i) {
            tagCompound = tagList.func_150305_b(i);
            slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound));
        }
        tagList = tag.func_150295_c("CraftingGrid", 10);
        this.craftingGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (i = 0; i < tagList.size(); ++i) {
            tagCompound = tagList.func_150305_b(i);
            slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.craftingGrid.size()) continue;
            this.craftingGrid.set((int)slot, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound));
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int i) {
        return i < 18 ? (ItemStack)this.inventory.get(i) : (ItemStack)this.craftingGrid.get(i - 18);
    }

    public ItemStack getStackInCraftingSlot(int i) {
        return (ItemStack)this.craftingGrid.get(i);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            } else if ((itemStack = itemStack.func_77979_a(amount)).func_190916_E() == 0) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        if (i < 18) {
            this.inventory.set(i, (Object)itemStack);
        } else {
            this.craftingGrid.set(i - 18, (Object)itemStack);
        }
    }

    public void setCraftingSlotContents(int i, ItemStack itemStack) {
        this.craftingGrid.set(i, (Object)itemStack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return player.func_180425_c().func_218141_a((Vec3i)this.field_174879_c, 64.0);
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("project_table");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerProjectTable(id, inventory, this);
    }
}

