/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPRecipeSerializer;
import com.bluepowermod.item.ItemSaw;
import com.google.gson.JsonObject;
import net.minecraft.block.Block;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MicroblockRecipe
extends SpecialRecipe {
    public MicroblockRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int blockCount = 0;
        int saw = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof BlockItem) {
                VoxelShape shape = null;
                try {
                    shape = Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_196954_c(null, null);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (shape != VoxelShapes.func_197868_b() && Block.func_149634_a((Item)stack.func_77973_b()) != BPBlocks.half_block && Block.func_149634_a((Item)stack.func_77973_b()) != BPBlocks.panel) continue;
                ++blockCount;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemSaw) {
                ++saw;
                continue;
            }
            return false;
        }
        return blockCount == 1 && saw == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem)) continue;
            if (Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P().func_196954_c(null, null) == VoxelShapes.func_197868_b()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("block", stack.func_77973_b().getRegistryName().toString());
                ItemStack outStack = new ItemStack((IItemProvider)BPBlocks.half_block, 2);
                outStack.func_77982_d(nbt);
                outStack.func_200302_a(new TranslationTextComponent(stack.func_77973_b().func_77658_a(), new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent(BPBlocks.half_block.func_149739_a(), new Object[0])));
                return outStack;
            }
            if (Block.func_149634_a((Item)stack.func_77973_b()) == BPBlocks.half_block) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74778_a("block", stack.func_77978_p().func_74779_i("block"));
                ItemStack outStack = new ItemStack((IItemProvider)BPBlocks.panel, 2);
                outStack.func_77982_d(nbt);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("block")));
                outStack.func_200302_a(new TranslationTextComponent(block.func_149739_a(), new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent(BPBlocks.panel.func_149739_a(), new Object[0])));
                return outStack;
            }
            if (Block.func_149634_a((Item)stack.func_77973_b()) != BPBlocks.panel) continue;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("block", stack.func_77978_p().func_74779_i("block"));
            ItemStack outStack = new ItemStack((IItemProvider)BPBlocks.cover, 2);
            outStack.func_77982_d(nbt);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("block")));
            outStack.func_200302_a(new TranslationTextComponent(block.func_149739_a(), new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent(BPBlocks.cover.func_149739_a(), new Object[0])));
            return outStack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return BPRecipeSerializer.MICROBLOCK;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MicroblockRecipe> {
        public MicroblockRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new MicroblockRecipe(recipeId);
        }

        public MicroblockRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new MicroblockRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, MicroblockRecipe recipe) {
        }
    }
}

