/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    public static void addVertex(double x, double y, double z) {
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void addVertexWithTexture(double x, double y, double z, double tx, double ty) {
        GL11.glTexCoord2d((double)tx, (double)ty);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static void renderPointer(double x, double y, double z, double angle) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)(180.0 + 360.0 * -angle), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minecraft:textures/blocks/stone.png"));
        GL11.glBegin((int)7);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0625, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.375, 0.0, 0.5, 0.375, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.625, 0.5, 0.625);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0625, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.625, 0.0, 0.5, 0.625, 0.5);
        RenderHelper.addVertexWithTexture(0.5, 0.0, 0.125, 0.5, 0.0625);
        RenderHelper.addVertexWithTexture(0.5, 0.0625, 0.125, 0.5, 0.0625);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void drawColoredCube(AxisAlignedBB vector) {
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
        RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
    }

    public static void drawColoredCube(AxisAlignedBB vector, double r, double g, double b, double a, boolean ... renderFaces) {
        GL11.glColor4d((double)r, (double)g, (double)b, (double)a);
        if (renderFaces.length < 1 || renderFaces[0]) {
            GL11.glNormal3d((double)0.0, (double)1.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
        }
        if (renderFaces.length < 2 || renderFaces[1]) {
            GL11.glNormal3d((double)0.0, (double)-1.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        }
        if (renderFaces.length < 3 || renderFaces[5]) {
            GL11.glNormal3d((double)-1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
        }
        if (renderFaces.length < 4 || renderFaces[4]) {
            GL11.glNormal3d((double)1.0, (double)0.0, (double)0.0);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
        }
        if (renderFaces.length < 5 || renderFaces[3]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)-1.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c);
        }
        if (renderFaces.length < 6 || renderFaces[2]) {
            GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f);
            RenderHelper.addVertex(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public static void drawColoredCube(AxisAlignedBB vector, IVertexBuilder vertexBuilder, MatrixStack matrixStack, int r, int g, int b, int a, int light, boolean ... renderFaces) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f positionMatrix = entry.func_227870_a_();
        Matrix3f normalMatrix = entry.func_227872_b_();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("minecraft:white_concrete", "")).func_177554_e();
        float minU = sprite.func_94209_e();
        float maxU = sprite.func_94212_f();
        float minV = sprite.func_94206_g();
        float maxV = sprite.func_94210_h();
        if (renderFaces.length < 1 || renderFaces[0]) {
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72337_e, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72337_e, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72337_e, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72337_e, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 1.0f, 0.0f).func_181675_d();
        }
        if (renderFaces.length < 2 || renderFaces[1]) {
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72338_b, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72338_b, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72338_b, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72338_b, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, -1.0f, 0.0f).func_181675_d();
        }
        if (renderFaces.length < 3 || renderFaces[5]) {
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72338_b, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, -1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72337_e, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, -1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72337_e, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, -1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72338_b, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, -1.0f, 0.0f, 0.0f).func_181675_d();
        }
        if (renderFaces.length < 4 || renderFaces[4]) {
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72338_b, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72337_e, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72337_e, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72338_b, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 1.0f, 0.0f, 0.0f).func_181675_d();
        }
        if (renderFaces.length < 5 || renderFaces[3]) {
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72338_b, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, -1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72337_e, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, -1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72337_e, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, -1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72338_b, (float)vector.field_72339_c).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, -1.0f).func_181675_d();
        }
        if (renderFaces.length < 6 || renderFaces[2]) {
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72338_b, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72338_b, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72336_d, (float)vector.field_72337_e, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
            vertexBuilder.func_227888_a_(positionMatrix, (float)vector.field_72340_a, (float)vector.field_72337_e, (float)vector.field_72334_f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, 0.0f, 0.0f, 1.0f).func_181675_d();
        }
    }

    public static void drawTesselatedTexturedCube(AxisAlignedBB vector) {
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder b = t.func_178180_c();
        boolean wasTesselating = false;
        try {
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        b.func_225582_a_(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f).func_225583_a_(minU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f).func_225583_a_(minU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c).func_225583_a_(maxU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c).func_225583_a_(maxU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f).func_225583_a_(minU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f).func_225583_a_(minU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c).func_225583_a_(maxU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c).func_225583_a_(maxU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f).func_225583_a_(minU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f).func_225583_a_(minU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c).func_225583_a_(maxU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c).func_225583_a_(maxU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c).func_225583_a_(minU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c).func_225583_a_(minU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f).func_225583_a_(maxU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f).func_225583_a_(maxU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72338_b, vector.field_72339_c).func_225583_a_(minU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72337_e, vector.field_72339_c).func_225583_a_(minU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72337_e, vector.field_72339_c).func_225583_a_(maxU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72338_b, vector.field_72339_c).func_225583_a_(maxU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72338_b, vector.field_72334_f).func_225583_a_(minU, maxV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72338_b, vector.field_72334_f).func_225583_a_(minU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72336_d, vector.field_72337_e, vector.field_72334_f).func_225583_a_(maxU, minV).func_181675_d();
        b.func_225582_a_(vector.field_72340_a, vector.field_72337_e, vector.field_72334_f).func_225583_a_(maxU, maxV).func_181675_d();
        if (!wasTesselating) {
            t.func_78381_a();
        }
    }

    public static void rotateRenderMatrix(Direction d) {
        switch (d) {
            case UP: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)-90.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)90.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)-90.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)90.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)180.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                break;
            }
        }
    }
}

