/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.BlockBPMicroblock;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.TileBPMicroblock;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BPMicroblockModel
implements IBakedModel {
    private Block defBlock = BPBlocks.marble;
    private Block defSize = BPBlocks.half_block;

    BPMicroblockModel() {
    }

    private BPMicroblockModel(Block defBlock, Block defSize) {
        this.defBlock = defBlock;
        this.defSize = defSize;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Pair info = (Pair)extraData.getData(TileBPMicroblock.PROPERTY_INFO);
        if (info != null) {
            IBakedModel typeModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(((Block)info.getKey()).func_176223_P());
            IBakedModel sizeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(this.defSize.getRegistryName(), "face=" + Direction.WEST));
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
            if (state != null && state.func_177230_c() instanceof BlockBPMicroblock) {
                sizeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(state.func_177230_c().getRegistryName(), "face=" + state.func_177229_b((IProperty)BlockBPMicroblock.FACING)));
            }
            List sizeModelQuads = sizeModel.func_200117_a(state, side, rand);
            if (state != null) {
                TextureAtlasSprite sprite = typeModel.func_177554_e();
                for (BakedQuad quad : sizeModelQuads) {
                    List typeModelQuads = typeModel.func_200117_a(((Block)info.getKey()).func_176223_P(), quad.func_178210_d(), rand);
                    if (typeModelQuads.size() > 0) {
                        sprite = ((BakedQuad)typeModelQuads.get(0)).func_187508_a();
                    }
                    bakedQuads.add(BPMicroblockModel.transform(quad, sprite, (Direction)state.func_177229_b((IProperty)BlockBPMicroblock.FACING)));
                }
                return bakedQuads;
            }
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        ArrayList<BakedQuad> outquads = new ArrayList<BakedQuad>();
        IBakedModel typeModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.defBlock.func_176223_P());
        IBakedModel sizeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(this.defSize.getRegistryName(), "face=" + Direction.WEST));
        if (state != null && state.func_177230_c() instanceof BlockBPMicroblock) {
            sizeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(state.func_177230_c().getRegistryName(), "face=" + state.func_177229_b((IProperty)BlockBPMicroblock.FACING)));
        }
        List sizeModelQuads = sizeModel.func_200117_a(state, side, rand);
        TextureAtlasSprite sprite = typeModel.func_177554_e();
        for (BakedQuad quad : sizeModelQuads) {
            List typeModelQuads = typeModel.func_200117_a(this.defBlock.func_176223_P(), quad.func_178210_d(), rand);
            if (typeModelQuads.size() > 0) {
                sprite = ((BakedQuad)typeModelQuads.get(0)).func_187508_a();
            }
            outquads.add(BPMicroblockModel.transform(quad, sprite, Direction.EAST));
        }
        return outquads;
    }

    private static BakedQuad transform(final BakedQuad sizeQuad, final TextureAtlasSprite sprite, Direction dir) {
        final BakedQuadBuilder builder = new BakedQuadBuilder();
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement e = (VertexFormatElement)this.getVertexFormat().func_227894_c_().get(element);
                if (e.func_177375_c() == VertexFormatElement.Usage.UV && e.func_177369_e() == 0) {
                    Vec2f vec = new Vec2f(data[0], data[1]);
                    float u = (vec.field_189982_i - sizeQuad.func_187508_a().func_94209_e()) / (sizeQuad.func_187508_a().func_94212_f() - sizeQuad.func_187508_a().func_94209_e()) * 16.0f;
                    float v = (vec.field_189983_j - sizeQuad.func_187508_a().func_94206_g()) / (sizeQuad.func_187508_a().func_94210_h() - sizeQuad.func_187508_a().func_94206_g()) * 16.0f;
                    builder.put(element, new float[]{sprite.func_94214_a((double)u), sprite.func_94207_b((double)v)});
                } else {
                    this.parent.put(element, data);
                }
            }
        };
        LightUtil.putBakedQuad((IVertexConsumer)consumer, (BakedQuad)sizeQuad);
        return builder.build();
    }

    public boolean doesHandlePerspectives() {
        return true;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack stack) {
        IBakedModel sizeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(this.defSize.getRegistryName(), "face=" + Direction.WEST));
        TransformationMatrix tr = TransformationHelper.toTransformation((ItemTransformVec3f)sizeModel.func_177552_f().func_181688_b(type));
        if (!tr.isIdentity()) {
            tr.push(stack);
        }
        return this;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        IBakedModel typeModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.defBlock.func_176223_P());
        return typeModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return new BakedMicroblockOverrideHandler();
    }

    private static final class BakedMicroblockOverrideHandler
    extends ItemOverrideList {
        private BakedMicroblockOverrideHandler() {
        }

        public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("block")) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("block")));
                return new BPMicroblockModel(block, Block.func_149634_a((Item)stack.func_77973_b()));
            }
            return new BPMicroblockModel(Blocks.field_150348_b, Block.func_149634_a((Item)stack.func_77973_b()));
        }
    }
}

