/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.FileUtil;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.AnvilSaveConverter;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.WorldPersistenceHooks;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormat {
    private static final Logger field_215785_a = LogManager.getLogger();
    private static final DateTimeFormatter field_197716_d = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Path field_215786_c;
    private final Path field_215787_d;
    private final DataFixer field_215788_e;

    public SaveFormat(Path p_i51277_1_, Path p_i51277_2_, DataFixer p_i51277_3_) {
        this.field_215788_e = p_i51277_3_;
        try {
            Files.createDirectories(Files.exists(p_i51277_1_, new LinkOption[0]) ? p_i51277_1_.toRealPath(new LinkOption[0]) : p_i51277_1_, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.field_215786_c = p_i51277_1_;
        this.field_215787_d = p_i51277_2_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_207741_a() {
        return "Anvil";
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WorldSummary> func_75799_b() throws AnvilConverterException {
        File[] afile;
        if (!Files.isDirectory(this.field_215786_c, new LinkOption[0])) {
            throw new AnvilConverterException(new TranslationTextComponent("selectWorld.load_folder_access", new Object[0]).getString());
        }
        ArrayList list = Lists.newArrayList();
        for (File file1 : afile = this.field_215786_c.toFile().listFiles()) {
            String s;
            WorldInfo worldinfo;
            if (!file1.isDirectory() || (worldinfo = this.func_75803_c(s = file1.getName())) == null || worldinfo.func_76088_k() != 19132 && worldinfo.func_76088_k() != 19133) continue;
            boolean flag = worldinfo.func_76088_k() != this.func_215782_e();
            String s1 = worldinfo.func_76065_j();
            if (StringUtils.isEmpty((CharSequence)s1)) {
                s1 = s;
            }
            long i = 0L;
            list.add(new WorldSummary(worldinfo, s, s1, 0L, flag));
        }
        return list;
    }

    private int func_215782_e() {
        return 19133;
    }

    public SaveHandler func_197715_a(String saveName, @Nullable MinecraftServer server) {
        return SaveFormat.func_215783_a(this.field_215786_c, this.field_215788_e, saveName, server);
    }

    protected static SaveHandler func_215783_a(Path p_215783_0_, DataFixer p_215783_1_, String p_215783_2_, @Nullable MinecraftServer p_215783_3_) {
        return new SaveHandler(p_215783_0_.toFile(), p_215783_2_, p_215783_3_, p_215783_1_);
    }

    public boolean func_75801_b(String saveName) {
        WorldInfo worldinfo = this.func_75803_c(saveName);
        return worldinfo != null && worldinfo.func_76088_k() != this.func_215782_e();
    }

    public boolean func_75805_a(String filename, IProgressUpdate progressCallback) {
        return AnvilSaveConverter.func_215792_a((Path)this.field_215786_c, (DataFixer)this.field_215788_e, (String)filename, (IProgressUpdate)progressCallback);
    }

    @Nullable
    public WorldInfo func_75803_c(String saveName) {
        return SaveFormat.func_215779_a(this.field_215786_c, this.field_215788_e, saveName);
    }

    @Nullable
    protected static WorldInfo func_215779_a(Path p_215779_0_, DataFixer p_215779_1_, String p_215779_2_) {
        WorldInfo worldinfo;
        File file1 = new File(p_215779_0_.toFile(), p_215779_2_);
        if (!file1.exists()) {
            return null;
        }
        File file2 = new File(file1, "level.dat");
        if (file2.exists() && (worldinfo = SaveFormat.func_215780_a(file2, p_215779_1_)) != null) {
            return worldinfo;
        }
        file2 = new File(file1, "level.dat_old");
        return file2.exists() ? SaveFormat.func_215780_a(file2, p_215779_1_) : null;
    }

    @Nullable
    public static WorldInfo func_215780_a(File p_215780_0_, DataFixer p_215780_1_) {
        return SaveFormat.getWorldData(p_215780_0_, p_215780_1_, null);
    }

    @Nullable
    public static WorldInfo getWorldData(File p_215780_0_, DataFixer p_215780_1_, @Nullable SaveHandler saveHandler) {
        try {
            CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream(p_215780_0_));
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("Data");
            CompoundNBT compoundnbt2 = compoundnbt1.func_150297_b("Player", 10) ? compoundnbt1.func_74775_l("Player") : null;
            compoundnbt1.func_82580_o("Player");
            int i = compoundnbt1.func_150297_b("DataVersion", 99) ? compoundnbt1.func_74762_e("DataVersion") : -1;
            WorldInfo ret = new WorldInfo(NBTUtil.func_210822_a((DataFixer)p_215780_1_, (DefaultTypeReferences)DefaultTypeReferences.LEVEL, (CompoundNBT)compoundnbt1, (int)i), p_215780_1_, i, compoundnbt2);
            if (saveHandler != null) {
                WorldPersistenceHooks.handleWorldDataLoad((SaveHandler)saveHandler, (WorldInfo)ret, (CompoundNBT)compoundnbt);
            }
            return ret;
        }
        catch (StartupQuery.AbortedException e) {
            throw e;
        }
        catch (Exception exception) {
            field_215785_a.error("Exception reading {}", (Object)p_215780_0_, (Object)exception);
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75806_a(String dirName, String newName) {
        File file2;
        File file1 = new File(this.field_215786_c.toFile(), dirName);
        if (file1.exists() && (file2 = new File(file1, "level.dat")).exists()) {
            try {
                CompoundNBT compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream(file2));
                CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("Data");
                compoundnbt1.func_74778_a("LevelName", newName);
                CompressedStreamTools.func_74799_a(compoundnbt, new FileOutputStream(file2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_207742_d(String saveName) {
        try {
            Path path = this.field_215786_c.resolve(saveName);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException var3) {
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_75802_e(String saveName) {
        File file1 = new File(this.field_215786_c.toFile(), saveName);
        if (!file1.exists()) {
            return true;
        }
        field_215785_a.info("Deleting level {}", (Object)saveName);
        for (int i = 1; i <= 5; ++i) {
            field_215785_a.info("Attempt {}...", (Object)i);
            if (SaveFormat.func_215784_a(file1.listFiles())) break;
            field_215785_a.warn("Unsuccessful in deleting contents.");
            if (i >= 5) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file1.delete();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean func_215784_a(File[] p_215784_0_) {
        for (File file1 : p_215784_0_) {
            field_215785_a.debug("Deleting {}", (Object)file1);
            if (file1.isDirectory() && !SaveFormat.func_215784_a(file1.listFiles())) {
                field_215785_a.warn("Couldn't delete directory {}", (Object)file1);
                return false;
            }
            if (file1.delete()) continue;
            field_215785_a.warn("Couldn't delete file {}", (Object)file1);
            return false;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90033_f(String saveName) {
        return Files.isDirectory(this.field_215786_c.resolve(saveName), new LinkOption[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Path func_215781_c() {
        return this.field_215786_c;
    }

    public File func_186352_b(String saveName, String filePath) {
        return this.field_215786_c.resolve(saveName).resolve(filePath).toFile();
    }

    @OnlyIn(value=Dist.CLIENT)
    private Path func_197714_g(String saveName) {
        return this.field_215786_c.resolve(saveName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Path func_197712_e() {
        return this.field_215787_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_197713_h(String worldName) throws IOException {
        final Path path = this.func_197714_g(worldName);
        String s = LocalDateTime.now().format(field_197716_d) + "_" + worldName;
        Path path1 = this.func_197712_e();
        try {
            Files.createDirectories(Files.exists(path1, new LinkOption[0]) ? path1.toRealPath(new LinkOption[0]) : path1, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        Path path2 = path1.resolve(FileUtil.func_214992_a((Path)path1, (String)s, (String)".zip"));
        try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path2, new OpenOption[0])));){
            final Path path3 = Paths.get(worldName, new String[0]);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p_visitFile_1_, BasicFileAttributes p_visitFile_2_) throws IOException {
                    String s1 = path3.resolve(path.relativize(p_visitFile_1_)).toString().replace('\\', '/');
                    ZipEntry zipentry = new ZipEntry(s1);
                    zipoutputstream.putNextEntry(zipentry);
                    com.google.common.io.Files.asByteSource((File)p_visitFile_1_.toFile()).copyTo((OutputStream)zipoutputstream);
                    zipoutputstream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return Files.size(path2);
    }
}

