/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ProjectileHelper {
    public static RayTraceResult func_221266_a(Entity projectile, boolean checkEntityCollision, boolean includeShooter, @Nullable Entity shooter, RayTraceContext.BlockMode blockModeIn) {
        return ProjectileHelper.func_221268_a(projectile, checkEntityCollision, includeShooter, shooter, blockModeIn, true, p_221270_2_ -> !p_221270_2_.func_175149_v() && p_221270_2_.func_70067_L() && (includeShooter || !p_221270_2_.func_70028_i(shooter)) && !p_221270_2_.field_70145_X, projectile.func_174813_aQ().func_216361_a(projectile.func_213322_ci()).func_186662_g(1.0));
    }

    public static RayTraceResult func_221267_a(Entity projectile, AxisAlignedBB boundingBox, Predicate<Entity> filter, RayTraceContext.BlockMode blockModeIn, boolean checkEntityCollision) {
        return ProjectileHelper.func_221268_a(projectile, checkEntityCollision, false, null, blockModeIn, false, filter, boundingBox);
    }

    @Nullable
    public static EntityRayTraceResult func_221271_a(World worldIn, Entity projectile, Vec3d startVec, Vec3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        return ProjectileHelper.func_221269_a(worldIn, projectile, startVec, endVec, boundingBox, filter, Double.MAX_VALUE);
    }

    private static RayTraceResult func_221268_a(Entity projectile, boolean checkEntityCollision, boolean includeShooter, @Nullable Entity shooter, RayTraceContext.BlockMode blockModeIn, boolean p_221268_5_, Predicate<Entity> filter, AxisAlignedBB boundingBox) {
        Vec3d vec3d = projectile.func_213322_ci();
        World world = projectile.field_70170_p;
        Vec3d vec3d1 = projectile.func_213303_ch();
        if (p_221268_5_ && !world.func_226662_a_(projectile, projectile.func_174813_aQ(), !includeShooter && shooter != null ? ProjectileHelper.func_211325_a(shooter) : ImmutableSet.of())) {
            return new BlockRayTraceResult(vec3d1, Direction.func_210769_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), new BlockPos(projectile), false);
        }
        Vec3d vec3d2 = vec3d1.func_178787_e(vec3d);
        BlockRayTraceResult raytraceresult = world.func_217299_a(new RayTraceContext(vec3d1, vec3d2, blockModeIn, RayTraceContext.FluidMode.NONE, projectile));
        if (checkEntityCollision) {
            EntityRayTraceResult raytraceresult1;
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d2 = raytraceresult.func_216347_e();
            }
            if ((raytraceresult1 = ProjectileHelper.func_221271_a(world, projectile, vec3d1, vec3d2, boundingBox, filter)) != null) {
                raytraceresult = raytraceresult1;
            }
        }
        return raytraceresult;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static EntityRayTraceResult func_221273_a(Entity shooter, Vec3d startVec, Vec3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        double d0 = distance;
        Entity entity = null;
        Vec3d vec3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, boundingBox, filter)) {
            Vec3d vec3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vec3d1 = (Vec3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3d = vec3d1;
                continue;
            }
            entity = entity1;
            vec3d = vec3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vec3d);
    }

    @Nullable
    public static EntityRayTraceResult func_221269_a(World worldIn, Entity projectile, Vec3d startVec, Vec3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        double d0 = distance;
        Entity entity = null;
        for (Entity entity1 : worldIn.func_175674_a(projectile, boundingBox, filter)) {
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e((Vec3d)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    private static Set<Entity> func_211325_a(Entity rider) {
        Entity entity = rider.func_184187_bx();
        return entity != null ? ImmutableSet.of((Object)((Object)rider), (Object)((Object)entity)) : ImmutableSet.of((Object)((Object)rider));
    }

    public static final void func_188803_a(Entity projectile, float rotationSpeed) {
        Vec3d vec3d = projectile.func_213322_ci();
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b(vec3d));
        projectile.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.2957763671875) + 90.0f;
        projectile.field_70125_A = (float)(MathHelper.func_181159_b((double)f, (double)vec3d.field_72448_b) * 57.2957763671875) - 90.0f;
        while (projectile.field_70125_A - projectile.field_70127_C < -180.0f) {
            projectile.field_70127_C -= 360.0f;
        }
        while (projectile.field_70125_A - projectile.field_70127_C >= 180.0f) {
            projectile.field_70127_C += 360.0f;
        }
        while (projectile.field_70177_z - projectile.field_70126_B < -180.0f) {
            projectile.field_70126_B -= 360.0f;
        }
        while (projectile.field_70177_z - projectile.field_70126_B >= 180.0f) {
            projectile.field_70126_B += 360.0f;
        }
        projectile.field_70125_A = MathHelper.func_219799_g((float)rotationSpeed, (float)projectile.field_70127_C, (float)projectile.field_70125_A);
        projectile.field_70177_z = MathHelper.func_219799_g((float)rotationSpeed, (float)projectile.field_70126_B, (float)projectile.field_70177_z);
    }

    public static Hand func_221274_a(LivingEntity living, Item itemIn) {
        return living.func_184614_ca().func_77973_b() == itemIn ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static AbstractArrowEntity func_221272_a(LivingEntity shooter, ItemStack arrowStack, float distanceFactor) {
        ArrowItem arrowitem = (ArrowItem)(arrowStack.func_77973_b() instanceof ArrowItem ? arrowStack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(shooter.field_70170_p, arrowStack, shooter);
        abstractarrowentity.func_190547_a(shooter, distanceFactor);
        if (arrowStack.func_77973_b() == Items.field_185167_i && abstractarrowentity instanceof ArrowEntity) {
            ((ArrowEntity)abstractarrowentity).func_184555_a(arrowStack);
        }
        return abstractarrowentity;
    }
}

