/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IShearable;

public class VineBlock
extends Block
implements IShearable {
    public static final BooleanProperty field_176277_a = SixWayBlock.field_196496_z;
    public static final BooleanProperty field_176273_b = SixWayBlock.field_196488_a;
    public static final BooleanProperty field_176278_M = SixWayBlock.field_196490_b;
    public static final BooleanProperty field_176279_N = SixWayBlock.field_196492_c;
    public static final BooleanProperty field_176280_O = SixWayBlock.field_196495_y;
    public static final Map<Direction, BooleanProperty> field_196546_A = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199782_0_ -> p_199782_0_.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    protected static final VoxelShape field_185757_g = Block.func_208617_a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185753_B = Block.func_208617_a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    protected static final VoxelShape field_185754_C = Block.func_208617_a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185755_D = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    protected static final VoxelShape field_185756_E = Block.func_208617_a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);

    public VineBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176277_a, Boolean.valueOf(false)))).func_206870_a((IProperty)field_176273_b, Boolean.valueOf(false)))).func_206870_a((IProperty)field_176278_M, Boolean.valueOf(false)))).func_206870_a((IProperty)field_176279_N, Boolean.valueOf(false)))).func_206870_a((IProperty)field_176280_O, Boolean.valueOf(false))));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape voxelshape = VoxelShapes.func_197880_a();
        if (((Boolean)state.func_177229_b((IProperty)field_176277_a)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185757_g);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176273_b)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185755_D);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176278_M)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185754_C);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176279_N)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185756_E);
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176280_O)).booleanValue()) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)field_185753_B);
        }
        return voxelshape;
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.func_196543_i(this.func_196545_h(state, (IBlockReader)((Object)worldIn), pos));
    }

    private boolean func_196543_i(BlockState p_196543_1_) {
        return this.func_208496_w(p_196543_1_) > 0;
    }

    private int func_208496_w(BlockState p_208496_1_) {
        int i = 0;
        for (BooleanProperty booleanproperty : field_196546_A.values()) {
            if (!((Boolean)p_208496_1_.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean func_196541_a(IBlockReader p_196541_1_, BlockPos p_196541_2_, Direction p_196541_3_) {
        if (p_196541_3_ == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = p_196541_2_.func_177972_a(p_196541_3_);
        if (VineBlock.func_196542_b(p_196541_1_, blockpos, p_196541_3_)) {
            return true;
        }
        if (p_196541_3_.func_176740_k() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = field_196546_A.get((Object)p_196541_3_);
        BlockState blockstate = p_196541_1_.func_180495_p(p_196541_2_.func_177984_a());
        return blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)booleanproperty) != false;
    }

    public static boolean func_196542_b(IBlockReader p_196542_0_, BlockPos worldIn, Direction neighborPos) {
        BlockState blockstate = p_196542_0_.func_180495_p(worldIn);
        return Block.func_208061_a(blockstate.func_196952_d(p_196542_0_, worldIn), neighborPos.func_176734_d());
    }

    private BlockState func_196545_h(BlockState p_196545_1_, IBlockReader p_196545_2_, BlockPos p_196545_3_) {
        BlockPos blockpos = p_196545_3_.func_177984_a();
        if (((Boolean)p_196545_1_.func_177229_b((IProperty)field_176277_a)).booleanValue()) {
            p_196545_1_ = (BlockState)((Object)p_196545_1_.func_206870_a((IProperty)field_176277_a, Boolean.valueOf(VineBlock.func_196542_b(p_196545_2_, blockpos, Direction.DOWN))));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = VineBlock.func_176267_a(direction);
            if (!((Boolean)p_196545_1_.func_177229_b((IProperty)booleanproperty)).booleanValue()) continue;
            boolean flag = this.func_196541_a(p_196545_2_, p_196545_3_, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = p_196545_2_.func_180495_p(blockpos);
                }
                flag = blockstate.func_177230_c() == this && (Boolean)blockstate.func_177229_b((IProperty)booleanproperty) != false;
            }
            p_196545_1_ = (BlockState)((Object)p_196545_1_.func_206870_a((IProperty)booleanproperty, Boolean.valueOf(flag)));
        }
        return p_196545_1_;
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        BlockState blockstate = this.func_196545_h(stateIn, (IBlockReader)((Object)worldIn), currentPos);
        return !this.func_196543_i(blockstate) ? Blocks.field_150350_a.func_176223_P() : blockstate;
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        BlockState blockstate = this.func_196545_h(state, (IBlockReader)((Object)worldIn), pos);
        if (blockstate != state) {
            if (this.func_196543_i(blockstate)) {
                worldIn.func_180501_a(pos, blockstate, 2);
            } else {
                VineBlock.func_220075_c(state, worldIn, pos);
                worldIn.func_217377_a(pos, false);
            }
        } else if (worldIn.field_73012_v.nextInt(4) == 0 && worldIn.isAreaLoaded(pos, 4)) {
            Direction direction = Direction.func_176741_a(rand);
            BlockPos blockpos = pos.func_177984_a();
            if (direction.func_176740_k().func_176722_c() && !((Boolean)state.func_177229_b((IProperty)VineBlock.func_176267_a(direction))).booleanValue()) {
                if (this.func_196539_a((IBlockReader)((Object)worldIn), pos)) {
                    BlockPos blockpos4 = pos.func_177972_a(direction);
                    BlockState blockstate5 = worldIn.func_180495_p(blockpos4);
                    if (blockstate5.isAir((IBlockReader)((Object)worldIn), blockpos4)) {
                        Direction direction3 = direction.func_176746_e();
                        Direction direction4 = direction.func_176735_f();
                        boolean flag = (Boolean)state.func_177229_b((IProperty)VineBlock.func_176267_a(direction3));
                        boolean flag1 = (Boolean)state.func_177229_b((IProperty)VineBlock.func_176267_a(direction4));
                        BlockPos blockpos2 = blockpos4.func_177972_a(direction3);
                        BlockPos blockpos3 = blockpos4.func_177972_a(direction4);
                        if (flag && VineBlock.func_196542_b((IBlockReader)((Object)worldIn), blockpos2, direction3)) {
                            worldIn.func_180501_a(blockpos4, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a(direction3), Boolean.valueOf(true))), 2);
                        } else if (flag1 && VineBlock.func_196542_b((IBlockReader)((Object)worldIn), blockpos3, direction4)) {
                            worldIn.func_180501_a(blockpos4, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a(direction4), Boolean.valueOf(true))), 2);
                        } else {
                            Direction direction1 = direction.func_176734_d();
                            if (flag && worldIn.func_175623_d(blockpos2) && VineBlock.func_196542_b((IBlockReader)((Object)worldIn), pos.func_177972_a(direction3), direction1)) {
                                worldIn.func_180501_a(blockpos2, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a(direction1), Boolean.valueOf(true))), 2);
                            } else if (flag1 && worldIn.func_175623_d(blockpos3) && VineBlock.func_196542_b((IBlockReader)((Object)worldIn), pos.func_177972_a(direction4), direction1)) {
                                worldIn.func_180501_a(blockpos3, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a(direction1), Boolean.valueOf(true))), 2);
                            } else if ((double)worldIn.field_73012_v.nextFloat() < 0.05 && VineBlock.func_196542_b((IBlockReader)((Object)worldIn), blockpos4.func_177984_a(), Direction.UP)) {
                                worldIn.func_180501_a(blockpos4, (BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_176277_a, Boolean.valueOf(true))), 2);
                            }
                        }
                    } else if (VineBlock.func_196542_b((IBlockReader)((Object)worldIn), blockpos4, direction)) {
                        worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)VineBlock.func_176267_a(direction), Boolean.valueOf(true))), 2);
                    }
                }
            } else {
                BlockState blockstate3;
                BlockState blockstate2;
                BlockPos blockpos1;
                BlockState blockstate1;
                if (direction == Direction.UP && pos.func_177956_o() < 255) {
                    if (this.func_196541_a((IBlockReader)((Object)worldIn), pos, direction)) {
                        worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_176277_a, Boolean.valueOf(true))), 2);
                        return;
                    }
                    if (worldIn.func_175623_d(blockpos)) {
                        if (!this.func_196539_a((IBlockReader)((Object)worldIn), pos)) {
                            return;
                        }
                        BlockState blockstate4 = state;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!rand.nextBoolean() && VineBlock.func_196542_b((IBlockReader)((Object)worldIn), blockpos.func_177972_a(direction2), Direction.UP)) continue;
                            blockstate4 = (BlockState)((Object)blockstate4.func_206870_a((IProperty)VineBlock.func_176267_a(direction2), Boolean.valueOf(false)));
                        }
                        if (this.func_196540_x(blockstate4)) {
                            worldIn.func_180501_a(blockpos, blockstate4, 2);
                        }
                        return;
                    }
                }
                if (pos.func_177956_o() > 0 && ((blockstate1 = worldIn.func_180495_p(blockpos1 = pos.func_177977_b())).isAir((IBlockReader)((Object)worldIn), blockpos1) || blockstate1.func_177230_c() == this) && (blockstate2 = blockstate1.isAir((IBlockReader)((Object)worldIn), blockpos1) ? this.func_176223_P() : blockstate1) != (blockstate3 = this.func_196544_a(state, blockstate2, rand)) && this.func_196540_x(blockstate3)) {
                    worldIn.func_180501_a(blockpos1, blockstate3, 2);
                }
            }
        }
    }

    private BlockState func_196544_a(BlockState p_196544_1_, BlockState p_196544_2_, Random p_196544_3_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_196544_3_.nextBoolean() || !((Boolean)p_196544_1_.func_177229_b((IProperty)(booleanproperty = VineBlock.func_176267_a(direction)))).booleanValue()) continue;
            p_196544_2_ = (BlockState)((Object)p_196544_2_.func_206870_a((IProperty)booleanproperty, Boolean.valueOf(true)));
        }
        return p_196544_2_;
    }

    private boolean func_196540_x(BlockState p_196540_1_) {
        return (Boolean)p_196540_1_.func_177229_b((IProperty)field_176273_b) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)field_176278_M) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)field_176279_N) != false || (Boolean)p_196540_1_.func_177229_b((IProperty)field_176280_O) != false;
    }

    private boolean func_196539_a(IBlockReader p_196539_1_, BlockPos p_196539_2_) {
        int i = 4;
        Iterable iterable = BlockPos.func_191531_b((int)(p_196539_2_.func_177958_n() - 4), (int)(p_196539_2_.func_177956_o() - 1), (int)(p_196539_2_.func_177952_p() - 4), (int)(p_196539_2_.func_177958_n() + 4), (int)(p_196539_2_.func_177956_o() + 1), (int)(p_196539_2_.func_177952_p() + 4));
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (p_196539_1_.func_180495_p(blockpos).func_177230_c() != this || --j > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        BlockState blockstate = useContext.func_195991_k().func_180495_p(useContext.func_195995_a());
        if (blockstate.func_177230_c() == this) {
            return this.func_208496_w(blockstate) < field_196546_A.size();
        }
        return super.func_196253_a(state, useContext);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        boolean flag = blockstate.func_177230_c() == this;
        BlockState blockstate1 = flag ? blockstate : this.func_176223_P();
        for (Direction direction : context.func_196009_e()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = VineBlock.func_176267_a(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.func_177229_b((IProperty)booleanproperty) != false;
            if (flag1 || !this.func_196541_a((IBlockReader)((Object)context.func_195991_k()), context.func_195995_a(), direction)) continue;
            return (BlockState)((Object)blockstate1.func_206870_a((IProperty)booleanproperty, Boolean.valueOf(true)));
        }
        return flag ? blockstate1 : null;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O});
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176279_N)))).func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176280_O)))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176273_b)))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176278_M)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176278_M)))).func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176279_N)))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176280_O)))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176273_b)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176280_O)))).func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176273_b)))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176278_M)))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176279_N)));
            }
        }
        return state;
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176279_N)))).func_206870_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176273_b)));
            }
            case FRONT_BACK: {
                return (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176280_O)))).func_206870_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176278_M)));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public static BooleanProperty func_176267_a(Direction side) {
        return field_196546_A.get((Object)side);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }
}

