/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.provider.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.valkyrieofnight.vlib.core.io.json.ITypedDeserializer;
import com.valkyrieofnight.vlib.registry.condition.data.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionID;
import com.valkyrieofnight.vlib.registry.condition.provider.ConditionProvider;
import java.lang.reflect.Type;

public abstract class JConditionProvider<PARENT_OBJECT> {
    protected static ConditionID getFromJson(JsonElement ele) {
        if (ele.isJsonPrimitive() && ele.getAsJsonPrimitive().isString()) {
            ConditionID cid = ConditionID.fromString(ele.getAsString());
            return cid;
        }
        return null;
    }

    public abstract void handleData(PARENT_OBJECT var1);

    public static class StringProviderDeserializer
    implements ITypedDeserializer<StringProvider> {
        @Override
        public TypeToken<StringProvider> getTypeToken() {
            return TypeToken.get(StringProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_string";
        }

        public StringProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                StringProvider stp = new StringProvider();
                stp.id = cid;
                return stp;
            }
            return null;
        }

        public static class StringProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<String>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<String> parent) {
            }
        }
    }

    public static class DoubleProviderDeserializer
    implements ITypedDeserializer<DoubleProvider> {
        @Override
        public TypeToken<DoubleProvider> getTypeToken() {
            return TypeToken.get(DoubleProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_double";
        }

        public DoubleProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                DoubleProvider dp = new DoubleProvider();
                dp.id = cid;
                return dp;
            }
            return null;
        }

        public static class DoubleProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Double>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Double> parent) {
            }
        }
    }

    public static class FloatProviderDeserializer
    implements ITypedDeserializer<FloatProvider> {
        @Override
        public TypeToken<FloatProvider> getTypeToken() {
            return TypeToken.get(FloatProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_float";
        }

        public FloatProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                FloatProvider fp = new FloatProvider();
                fp.id = cid;
                return fp;
            }
            return null;
        }

        public static class FloatProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Float>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Float> parent) {
            }
        }
    }

    public static class LongProviderDeserializer
    implements ITypedDeserializer<LongProvider> {
        @Override
        public TypeToken<LongProvider> getTypeToken() {
            return TypeToken.get(LongProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_long";
        }

        public LongProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                LongProvider lp = new LongProvider();
                lp.id = cid;
                return lp;
            }
            return null;
        }

        public static class LongProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Long>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Long> parent) {
            }
        }
    }

    public static class IntProviderDeserializer
    implements ITypedDeserializer<IntProvider> {
        @Override
        public TypeToken<IntProvider> getTypeToken() {
            return TypeToken.get(IntProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_int";
        }

        public IntProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                IntProvider ip = new IntProvider();
                ip.id = cid;
                return ip;
            }
            return null;
        }

        public static class IntProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Integer>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Integer> parent) {
            }
        }
    }

    public static class ShortProviderDeserializer
    implements ITypedDeserializer<ShortProvider> {
        @Override
        public TypeToken<ShortProvider> getTypeToken() {
            return TypeToken.get(ShortProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_short";
        }

        public ShortProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                ShortProvider sp = new ShortProvider();
                sp.id = cid;
                return sp;
            }
            return null;
        }

        public static class ShortProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Short>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Short> parent) {
            }
        }
    }

    public static class ByteProviderDeserializer
    implements ITypedDeserializer<ByteProvider> {
        @Override
        public TypeToken<ByteProvider> getTypeToken() {
            return TypeToken.get(ByteProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_byte";
        }

        public ByteProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                ByteProvider bp = new ByteProvider();
                bp.id = cid;
                return bp;
            }
            return null;
        }

        public static class ByteProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Byte>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Byte> parent) {
                parent.injectHandler(new ConditionProvider<Byte>(){

                    @Override
                    public Byte request(ConditionDataContainer dataContainer) {
                        return (Byte)dataContainer.getByteCondition(id).getValue();
                    }
                });
            }
        }
    }

    public static class BooleanProviderDeserializer
    implements ITypedDeserializer<BooleanProvider> {
        @Override
        public TypeToken<BooleanProvider> getTypeToken() {
            return TypeToken.get(BooleanProvider.class);
        }

        @Override
        public String getTypeIdentifier() {
            return "condition_value_boolean";
        }

        public BooleanProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ConditionID cid = JConditionProvider.getFromJson(json);
            if (cid != null) {
                BooleanProvider bp = new BooleanProvider();
                bp.id = cid;
                return bp;
            }
            return null;
        }

        public static class BooleanProvider
        extends JConditionProvider<ConditionProvider.ConditionProviderHandler<Boolean>> {
            protected ConditionID id;

            @Override
            public void handleData(ConditionProvider.ConditionProviderHandler<Boolean> parent) {
                parent.injectHandler(new ConditionProvider<Boolean>(){

                    @Override
                    public Boolean request(ConditionDataContainer dataContainer) {
                        return (Boolean)dataContainer.getBooleanCondition(id).getValue();
                    }
                });
            }
        }
    }
}

