/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.provider.base;

import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import com.valkyrieofnight.vlib.registry.condition.data.ConditionDataContainer;
import com.valkyrieofnight.vlib.registry.condition.provider.IConditionalProvider;

public abstract class IfElseProvider<RETURN_VALUE, TEST_TYPE>
implements IConditionalProvider<RETURN_VALUE> {
    protected final IConditionalProvider<TEST_TYPE> left;
    protected final RelationalOperator testType;
    protected final IConditionalProvider<TEST_TYPE> right;
    protected final IConditionalProvider<RETURN_VALUE> trueReturn;
    protected final IConditionalProvider<RETURN_VALUE> falseReturn;

    public IfElseProvider(IConditionalProvider<TEST_TYPE> left, RelationalOperator testType, IConditionalProvider<TEST_TYPE> right, IConditionalProvider<RETURN_VALUE> trueValue, IConditionalProvider<RETURN_VALUE> falseValue) {
        this.left = left;
        this.testType = testType;
        this.right = right;
        this.trueReturn = trueValue;
        this.falseReturn = falseValue;
    }

    @Override
    public final RETURN_VALUE request(ConditionDataContainer container) {
        if (this.test(container, this.left, this.testType, this.right)) {
            return this.trueReturn.request(container);
        }
        return this.falseReturn.request(container);
    }

    protected abstract boolean test(ConditionDataContainer var1, IConditionalProvider<TEST_TYPE> var2, RelationalOperator var3, IConditionalProvider<TEST_TYPE> var4);

    public static class TestString<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, String> {
        public TestString(IConditionalProvider<String> left, RelationalOperator testType, IConditionalProvider<String> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<String> left, RelationalOperator operator, IConditionalProvider<String> right) {
            String lv = left.request(container);
            String rv = right.request(container);
            if (lv == null || rv == null) {
                return false;
            }
            switch (operator) {
                case EQUAL: {
                    return lv.equals(rv);
                }
                case NOT_EQUAL: {
                    return !lv.equals(rv);
                }
            }
            return false;
        }
    }

    public static class TestDouble<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Double> {
        public TestDouble(IConditionalProvider<Double> left, RelationalOperator testType, IConditionalProvider<Double> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Double> left, RelationalOperator operator, IConditionalProvider<Double> right) {
            double lv = left.request(container);
            double rv = right.request(container);
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
                case GREATER_THAN: {
                    return lv > rv;
                }
                case LESS_THAN: {
                    return lv < rv;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return lv >= rv;
                }
                case LESS_THAN_OR_EQUAL: {
                    return lv <= rv;
                }
            }
            return false;
        }
    }

    public static class TestFloat<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Float> {
        public TestFloat(IConditionalProvider<Float> left, RelationalOperator testType, IConditionalProvider<Float> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Float> left, RelationalOperator operator, IConditionalProvider<Float> right) {
            float lv = left.request(container).floatValue();
            float rv = right.request(container).floatValue();
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
                case GREATER_THAN: {
                    return lv > rv;
                }
                case LESS_THAN: {
                    return lv < rv;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return lv >= rv;
                }
                case LESS_THAN_OR_EQUAL: {
                    return lv <= rv;
                }
            }
            return false;
        }
    }

    public static class TestLong<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Long> {
        public TestLong(IConditionalProvider<Long> left, RelationalOperator testType, IConditionalProvider<Long> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Long> left, RelationalOperator operator, IConditionalProvider<Long> right) {
            long lv = left.request(container);
            long rv = right.request(container);
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
                case GREATER_THAN: {
                    return lv > rv;
                }
                case LESS_THAN: {
                    return lv < rv;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return lv >= rv;
                }
                case LESS_THAN_OR_EQUAL: {
                    return lv <= rv;
                }
            }
            return false;
        }
    }

    public static class TestInt<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Integer> {
        public TestInt(IConditionalProvider<Integer> left, RelationalOperator testType, IConditionalProvider<Integer> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Integer> left, RelationalOperator operator, IConditionalProvider<Integer> right) {
            int lv = left.request(container);
            int rv = right.request(container);
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
                case GREATER_THAN: {
                    return lv > rv;
                }
                case LESS_THAN: {
                    return lv < rv;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return lv >= rv;
                }
                case LESS_THAN_OR_EQUAL: {
                    return lv <= rv;
                }
            }
            return false;
        }
    }

    public static class TestShort<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Short> {
        public TestShort(IConditionalProvider<Short> left, RelationalOperator testType, IConditionalProvider<Short> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Short> left, RelationalOperator operator, IConditionalProvider<Short> right) {
            short lv = left.request(container);
            short rv = right.request(container);
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
                case GREATER_THAN: {
                    return lv > rv;
                }
                case LESS_THAN: {
                    return lv < rv;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return lv >= rv;
                }
                case LESS_THAN_OR_EQUAL: {
                    return lv <= rv;
                }
            }
            return false;
        }
    }

    public static class TestByte<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Byte> {
        public TestByte(IConditionalProvider<Byte> left, RelationalOperator testType, IConditionalProvider<Byte> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Byte> left, RelationalOperator operator, IConditionalProvider<Byte> right) {
            byte lv = left.request(container);
            byte rv = right.request(container);
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
                case GREATER_THAN: {
                    return lv > rv;
                }
                case LESS_THAN: {
                    return lv < rv;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return lv >= rv;
                }
                case LESS_THAN_OR_EQUAL: {
                    return lv <= rv;
                }
            }
            return false;
        }
    }

    public static class TestBoolean<RETURN_TYPE>
    extends IfElseProvider<RETURN_TYPE, Boolean> {
        public TestBoolean(IConditionalProvider<Boolean> left, RelationalOperator testType, IConditionalProvider<Boolean> right, IConditionalProvider<RETURN_TYPE> trueValue, IConditionalProvider<RETURN_TYPE> falseValue) {
            super(left, testType, right, trueValue, falseValue);
        }

        @Override
        protected boolean test(ConditionDataContainer container, IConditionalProvider<Boolean> left, RelationalOperator operator, IConditionalProvider<Boolean> right) {
            boolean lv = left.request(container);
            boolean rv = right.request(container);
            switch (operator) {
                case EQUAL: {
                    return lv == rv;
                }
                case NOT_EQUAL: {
                    return lv != rv;
                }
            }
            return false;
        }
    }
}

