/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.condition.data;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.io.nbt.INBTHandler;
import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionID;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionScope;
import com.valkyrieofnight.vlib.registry.condition.data.base.ConditionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class ConditionData<FINAL_TYPE extends ConditionData, VARIABLE_TYPE>
implements INBTHandler<FINAL_TYPE> {
    protected ConditionID id;
    protected ConditionType type;
    protected List<ConditionScope> scopes = Lists.newArrayList();
    protected VARIABLE_TYPE value;
    protected VARIABLE_TYPE valueDefault;

    public ConditionData(ConditionID id, ConditionType type, List<ConditionScope> scopes, VARIABLE_TYPE valueDefault) {
        this.id = id;
        this.type = type;
        this.valueDefault = valueDefault;
        this.scopes.addAll(scopes);
    }

    protected ConditionScope[] getScopesArray() {
        return this.scopes.toArray(new ConditionScope[this.scopes.size()]);
    }

    public final VARIABLE_TYPE getValue() {
        return this.value;
    }

    public void setValue(VARIABLE_TYPE value) {
        this.value = value;
    }

    public ConditionID getId() {
        return this.id;
    }

    public boolean isValidScope(ConditionScope scope) {
        return scope != null ? this.scopes.contains((Object)scope) : false;
    }

    public abstract boolean testCondition(RelationalOperator var1, VARIABLE_TYPE var2);

    public abstract FINAL_TYPE copy();

    public abstract void applyParameters(FINAL_TYPE var1);

    public static class StringCondition
    extends ConditionData<StringCondition, String> {
        public static StringCondition EMPTY = new StringCondition(ConditionID.fromString("empty:string"), Lists.newArrayList((Object[])ConditionScope.getAll()), "");

        public StringCondition(ConditionID id, List<ConditionScope> scopes, String valueDefault) {
            super(id, ConditionType.STRING, scopes, valueDefault);
        }

        @Override
        public boolean testCondition(RelationalOperator operator, String other) {
            if (other == null || this.value == null) {
                return false;
            }
            switch (operator) {
                case EQUAL: {
                    return ((String)this.value).equals(other);
                }
                case NOT_EQUAL: {
                    return !((String)this.value).equals(other);
                }
            }
            return false;
        }

        @Override
        public StringCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new StringCondition(this.id, copy, (String)this.valueDefault);
        }

        @Override
        public void applyParameters(StringCondition template) {
            this.valueDefault = template.valueDefault;
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public StringCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74779_i("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74778_a("value", (String)this.value);
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class DoubleCondition
    extends ConditionData<DoubleCondition, Double> {
        public static DoubleCondition EMPTY = new DoubleCondition(ConditionID.fromString("empty:double"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0.0);
        protected double min;
        protected double max;

        public DoubleCondition(ConditionID id, List<ConditionScope> scopes, double valueDefault) {
            this(id, scopes, valueDefault, Double.MIN_VALUE, Double.MAX_VALUE);
        }

        public DoubleCondition(ConditionID id, List<ConditionScope> scopes, double valueDefault, double min, double max) {
            super(id, ConditionType.DOUBLE, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean testCondition(RelationalOperator operator, Double other) {
            switch (operator) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
                case LESS_THAN: {
                    return (Double)this.value < other;
                }
                case LESS_THAN_OR_EQUAL: {
                    return (Double)this.value <= other;
                }
                case GREATER_THAN: {
                    return (Double)this.value > other;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return (Double)this.value >= other;
                }
            }
            return false;
        }

        @Override
        public DoubleCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new DoubleCondition(this.id, copy, (Double)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(DoubleCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Double)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public DoubleCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74769_h("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74780_a("value", ((Double)this.value).doubleValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class FloatCondition
    extends ConditionData<FloatCondition, Float> {
        public static FloatCondition EMPTY = new FloatCondition(ConditionID.fromString("empty:float"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0.0f);
        protected float min;
        protected float max;

        public FloatCondition(ConditionID id, List<ConditionScope> scopes, float valueDefault) {
            this(id, scopes, valueDefault, Float.MIN_VALUE, Float.MAX_VALUE);
        }

        public FloatCondition(ConditionID id, List<ConditionScope> scopes, float valueDefault, float min, float max) {
            super(id, ConditionType.FLOAT, scopes, Float.valueOf(valueDefault));
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean testCondition(RelationalOperator operator, Float other) {
            switch (operator) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
                case LESS_THAN: {
                    return ((Float)this.value).floatValue() < other.floatValue();
                }
                case LESS_THAN_OR_EQUAL: {
                    return ((Float)this.value).floatValue() <= other.floatValue();
                }
                case GREATER_THAN: {
                    return ((Float)this.value).floatValue() > other.floatValue();
                }
                case GREATER_THAN_OR_EQUAL: {
                    return ((Float)this.value).floatValue() >= other.floatValue();
                }
            }
            return false;
        }

        @Override
        public FloatCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new FloatCondition(this.id, copy, ((Float)this.valueDefault).floatValue(), this.min, this.max);
        }

        @Override
        public void applyParameters(FloatCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = Float.valueOf(MathUtil.clamp(((Float)this.value).floatValue(), this.min, this.max));
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public FloatCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = Float.valueOf(n.func_74760_g("value"));
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74776_a("value", ((Float)this.value).floatValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class LongCondition
    extends ConditionData<LongCondition, Long> {
        public static LongCondition EMPTY = new LongCondition(ConditionID.fromString("empty:long"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0L);
        protected long min;
        protected long max;

        public LongCondition(ConditionID id, List<ConditionScope> scopes, long valueDefault) {
            this(id, scopes, valueDefault, Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public LongCondition(ConditionID id, List<ConditionScope> scopes, long valueDefault, long min, long max) {
            super(id, ConditionType.LONG, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean testCondition(RelationalOperator operator, Long other) {
            switch (operator) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
                case LESS_THAN: {
                    return (Long)this.value < other;
                }
                case LESS_THAN_OR_EQUAL: {
                    return (Long)this.value <= other;
                }
                case GREATER_THAN: {
                    return (Long)this.value > other;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return (Long)this.value >= other;
                }
            }
            return false;
        }

        @Override
        public LongCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new LongCondition(this.id, copy, (Long)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(LongCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Long)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public LongCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74763_f("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74772_a("value", ((Long)this.value).longValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class IntCondition
    extends ConditionData<IntCondition, Integer> {
        public static IntCondition EMPTY = new IntCondition(ConditionID.fromString("empty:int"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0);
        protected int min;
        protected int max;

        public IntCondition(ConditionID id, List<ConditionScope> scopes, int valueDefault) {
            this(id, scopes, valueDefault, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public IntCondition(ConditionID id, List<ConditionScope> scopes, int valueDefault, int min, int max) {
            super(id, ConditionType.SHORT, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean testCondition(RelationalOperator operator, Integer other) {
            switch (operator) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
                case LESS_THAN: {
                    return (Integer)this.value < other;
                }
                case LESS_THAN_OR_EQUAL: {
                    return (Integer)this.value <= other;
                }
                case GREATER_THAN: {
                    return (Integer)this.value > other;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return (Integer)this.value >= other;
                }
            }
            return false;
        }

        @Override
        public IntCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new IntCondition(this.id, copy, (Integer)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(IntCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Integer)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public IntCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74762_e("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74768_a("value", ((Integer)this.value).intValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class ShortCondition
    extends ConditionData<ShortCondition, Short> {
        public static ShortCondition EMPTY = new ShortCondition(ConditionID.fromString("empty:short"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0);
        protected short min;
        protected short max;

        public ShortCondition(ConditionID id, List<ConditionScope> scopes, short valueDefault) {
            this(id, scopes, valueDefault, Short.MIN_VALUE, Short.MAX_VALUE);
        }

        public ShortCondition(ConditionID id, List<ConditionScope> scopes, short valueDefault, short min, short max) {
            super(id, ConditionType.SHORT, scopes, valueDefault);
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean testCondition(RelationalOperator operator, Short other) {
            switch (operator) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
                case LESS_THAN: {
                    return (Short)this.value < other;
                }
                case LESS_THAN_OR_EQUAL: {
                    return (Short)this.value <= other;
                }
                case GREATER_THAN: {
                    return (Short)this.value > other;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return (Short)this.value >= other;
                }
            }
            return false;
        }

        @Override
        public ShortCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new ShortCondition(this.id, copy, (Short)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(ShortCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Short)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public ShortCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74765_d("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74777_a("value", ((Short)this.value).shortValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class ByteCondition
    extends ConditionData<ByteCondition, Byte> {
        public static ByteCondition EMPTY = new ByteCondition(ConditionID.fromString("empty:byte"), Lists.newArrayList((Object[])ConditionScope.getAll()), 0);
        protected byte min;
        protected byte max;

        public ByteCondition(ConditionID id, List<ConditionScope> scopes, byte valueDefault) {
            this(id, scopes, valueDefault, -128, 127);
        }

        public ByteCondition(ConditionID id, List<ConditionScope> scopes, byte valueDefault, byte valueMin, byte valueMax) {
            super(id, ConditionType.BYTE, scopes, valueDefault);
            this.min = valueMin;
            this.max = valueMax;
        }

        @Override
        public void setValue(Byte value) {
            this.value = MathUtil.clamp(value, this.min, this.max);
        }

        @Override
        public boolean testCondition(RelationalOperator operator, Byte other) {
            switch (operator) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
                case LESS_THAN: {
                    return (Byte)this.value < other;
                }
                case LESS_THAN_OR_EQUAL: {
                    return (Byte)this.value <= other;
                }
                case GREATER_THAN: {
                    return (Byte)this.value > other;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return (Byte)this.value >= other;
                }
            }
            return false;
        }

        @Override
        public ByteCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new ByteCondition(this.id, copy, (Byte)this.valueDefault, this.min, this.max);
        }

        @Override
        public void applyParameters(ByteCondition template) {
            this.valueDefault = template.valueDefault;
            this.min = template.min;
            this.max = template.max;
            this.value = MathUtil.clamp((Byte)this.value, this.min, this.max);
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public ByteCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74771_c("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74774_a("value", ((Byte)this.value).byteValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }

    public static class BooleanCondition
    extends ConditionData<BooleanCondition, Boolean> {
        public static BooleanCondition EMPTY = new BooleanCondition(ConditionID.fromString("empty:boolean"), Lists.newArrayList((Object[])ConditionScope.getAll()), false);

        public BooleanCondition(ConditionID id, List<ConditionScope> scopes, boolean valueDefault) {
            super(id, ConditionType.BOOLEAN, scopes, valueDefault);
        }

        @Override
        public boolean testCondition(RelationalOperator operators, Boolean other) {
            switch (operators) {
                case EQUAL: {
                    return this.value == other;
                }
                case NOT_EQUAL: {
                    return this.value != other;
                }
            }
            return false;
        }

        @Override
        public BooleanCondition copy() {
            ArrayList copy = Lists.newArrayList();
            Collections.copy(copy, this.scopes);
            return new BooleanCondition(this.id, copy, (Boolean)this.valueDefault);
        }

        @Override
        public void applyParameters(BooleanCondition template) {
            this.valueDefault = template.valueDefault;
            this.scopes.clear();
            this.scopes.addAll(template.scopes);
        }

        @Override
        public BooleanCondition readFromNBT(CompoundNBT nbt) {
            CompoundNBT n = nbt.func_74775_l(this.id.toString());
            if (n != null) {
                this.value = n.func_74767_n("value");
            }
            return this;
        }

        @Override
        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            CompoundNBT n = new CompoundNBT();
            n.func_74757_a("value", ((Boolean)this.value).booleanValue());
            nbt.func_218657_a(this.id.toString(), (INBT)n);
            return nbt;
        }
    }
}

