/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.lambda.Action3a;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.core.util.math.XYZOrientation;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.component.ComponentLayoutList;
import com.valkyrieofnight.vlib.multiblock.component.ComponentRegistry;
import com.valkyrieofnight.vlib.multiblock.component.ComponentSettings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Structure {
    private String unlocalizedName;
    private LinkedHashMap<Component, ComponentLayoutList> layoutListMap;
    private Map<Component, ComponentSettings> settingsMap;
    private Map<BlockOffset, Component> componentMap;
    private LinkedList<XYZOrientation> validOrientations;
    private Map<Component, Action3a<Component, World, BlockPos>> creativePlacers;

    private Structure(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public Set<Component> getComponents() {
        return this.layoutListMap.keySet();
    }

    public ComponentLayoutList getLayoutList(Component comp) {
        if (comp == null) {
            return null;
        }
        return this.layoutListMap.get(comp);
    }

    public ComponentLayoutList getLayoutList(BlockOffset offset) {
        if (offset == null) {
            return null;
        }
        for (ComponentLayoutList list : this.layoutListMap.values()) {
            if (!list.contains(offset)) continue;
            return list;
        }
        return null;
    }

    public ComponentSettings getComponentSettings(Component comp) {
        if (comp == null) {
            return null;
        }
        return this.settingsMap.get(comp);
    }

    public Component getComponent(BlockOffset offset) {
        if (offset == null) {
            return null;
        }
        return this.componentMap.get(offset);
    }

    public XYZOrientation getNextOrientation(XYZOrientation current) {
        int i = this.validOrientations.indexOf((Object)current) + 1;
        if (i >= this.validOrientations.size()) {
            return this.validOrientations.get(0);
        }
        return this.validOrientations.get(i);
    }

    public boolean isOffsetOccupied(BlockOffset offset) {
        return this.componentMap.containsKey(offset);
    }

    public Map<BlockOffset, Boolean> getBlankClaimedStateMap() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        for (ComponentLayoutList list : this.layoutListMap.values()) {
            for (BlockOffset o : list.getAll()) {
                r.put(o, false);
            }
        }
        return r;
    }

    public boolean contains(BlockOffset off) {
        if (off == null) {
            return false;
        }
        return this.componentMap.containsKey(off);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public static class Builder {
        private String unlocalizedName;
        private LinkedHashMap<Component, ComponentLayoutList> layoutListMap = Maps.newLinkedHashMap();
        private Map<Component, ComponentSettings> settingsMap = Maps.newHashMap();
        private LinkedList<XYZOrientation> validOrientations = Lists.newLinkedList();
        private Map<Component, Action3a<Component, World, BlockPos>> creativePlacers = Maps.newLinkedHashMap();

        public static Builder create(String unlocalizedName) {
            return new Builder(unlocalizedName);
        }

        private Builder(String unlocalizedName) {
            this.unlocalizedName = unlocalizedName;
        }

        public void addCreativePlacer(Component comp, Action3a<Component, World, BlockPos> placer) {
            if (placer != null && comp != null) {
                this.creativePlacers.put(comp, placer);
            }
        }

        private boolean isOffsetOccupied(BlockOffset offset) {
            for (ComponentLayoutList list : this.layoutListMap.values()) {
                if (!list.contains(offset)) continue;
                return true;
            }
            return false;
        }

        private void createBase(Component comp) {
            this.layoutListMap.put(comp, new ComponentLayoutList(comp));
            this.settingsMap.put(comp, new ComponentSettings());
        }

        public Builder copy(Structure structure, Component component) {
            ComponentLayoutList cll = structure.getLayoutList(component);
            for (BlockOffset bo : cll.getAll()) {
                this.addComponent(component, bo);
            }
            return this;
        }

        public Builder copy(Structure structure) {
            for (Component comp : structure.getComponents()) {
                this.copy(structure, comp);
            }
            return this;
        }

        public Builder addValidOrientation(XYZOrientation direction) {
            if (direction == null || this.validOrientations.contains((Object)direction)) {
                return this;
            }
            this.validOrientations.add(direction);
            return this;
        }

        public Builder addValidOrientation(XYZOrientation ... orientations) {
            for (XYZOrientation o : orientations) {
                this.addValidOrientation(o);
            }
            return this;
        }

        public Builder addComponent(Component comp, BlockOffset offset) {
            if (comp == null) {
                throw new NullPointerException("Component provided was null");
            }
            if (offset == null) {
                throw new NullPointerException("BlockOffset provided was null");
            }
            if (!ComponentRegistry.getInstance().isRegistered(comp.getID())) {
                throw new RuntimeException("Component with id: " + comp.getID() + " is not registered. Please register in order to use it inside of a Structure.");
            }
            if (this.isOffsetOccupied(offset)) {
                throw new RuntimeException("BlockOffset at: " + offset + " is already occupied with another component.");
            }
            if (!this.layoutListMap.containsKey(comp)) {
                this.createBase(comp);
            }
            ComponentLayoutList list = this.layoutListMap.get(comp);
            list.add(offset);
            return this;
        }

        public Builder addComponent(Component comp, int xOffset, int yOffset, int zOffset) {
            this.addComponent(comp, new BlockOffset(xOffset, yOffset, zOffset));
            return this;
        }

        public Builder addComponentParallelX(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
            }
            return this;
        }

        public Builder addComponentParallelY(Component comp, int xOffset, int yOffset, int zOffset) {
            if (yOffset == 0) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, -yOffset, zOffset);
            }
            return this;
        }

        public Builder addComponentParallelZ(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
            }
            return this;
        }

        public Builder addComponentSymmetricalXZ(Component comp, int xOffset, int yOffset, int zOffset) {
            if (xOffset == 0 && zOffset == 0) {
                if (yOffset == 0) {
                    return this;
                }
                this.addComponent(comp, xOffset, yOffset, zOffset);
            } else if (Math.abs(xOffset) == Math.abs(zOffset)) {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
                this.addComponent(comp, -xOffset, yOffset, -zOffset);
            } else if (xOffset == 0 || zOffset == 0) {
                int off = Math.max(xOffset, zOffset);
                this.addComponent(comp, off, yOffset, 0);
                this.addComponent(comp, -off, yOffset, 0);
                this.addComponent(comp, 0, yOffset, off);
                this.addComponent(comp, 0, yOffset, -off);
            } else {
                this.addComponent(comp, xOffset, yOffset, zOffset);
                this.addComponent(comp, -xOffset, yOffset, zOffset);
                this.addComponent(comp, xOffset, yOffset, -zOffset);
                this.addComponent(comp, -xOffset, yOffset, -zOffset);
                this.addComponent(comp, zOffset, yOffset, xOffset);
                this.addComponent(comp, -zOffset, yOffset, xOffset);
                this.addComponent(comp, zOffset, yOffset, -xOffset);
                this.addComponent(comp, -zOffset, yOffset, -xOffset);
            }
            return this;
        }

        public Structure build() {
            Structure s = new Structure(this.unlocalizedName);
            s.settingsMap = this.settingsMap;
            s.layoutListMap = this.layoutListMap;
            s.validOrientations = this.validOrientations;
            if (s.validOrientations.isEmpty()) {
                s.validOrientations.add(XYZOrientation.PXPYPZ);
                s.validOrientations.add(XYZOrientation.PXPYNX);
                s.validOrientations.add(XYZOrientation.NXPYNZ);
                s.validOrientations.add(XYZOrientation.NZPYPX);
            }
            s.creativePlacers = this.creativePlacers;
            s.componentMap = Maps.newLinkedHashMap();
            for (ComponentLayoutList l : this.layoutListMap.values()) {
                for (BlockOffset o : l.getAll()) {
                    s.componentMap.put(o, l.getComponent());
                }
            }
            return s;
        }
    }
}

