/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.util;

import com.valkyrieofnight.vlib.core.util.wrapped.VLID;

public class GuiTexture {
    public final int startX;
    public final int startY;
    public final int endX;
    public final int endY;
    public final int width;
    public final int height;
    public final VLID texture;
    private int texWidth;
    private int texHeight;

    public GuiTexture(VLID tex, int startX, int startY, int endX, int endY) {
        this(tex, startX, startY, endX, endY, 256, 256);
    }

    public GuiTexture(VLID tex, int startX, int startY, int endX, int endY, int textureWidth, int textureHeight) {
        this.texture = tex;
        this.startX = startX;
        this.startY = startY;
        this.endX = endX;
        this.endY = endY;
        this.width = this.endX - this.startX;
        this.height = this.endY - this.startY;
        this.texWidth = textureWidth;
        this.texHeight = textureHeight;
    }

    public void setTexSize(int w, int h) {
        this.texWidth = w;
        this.texHeight = h;
    }

    public int getTexW() {
        return this.texWidth;
    }

    public int getTexH() {
        return this.texHeight;
    }

    public static GuiTexture create(VLID loc, int x, int y, int w, int h) {
        return new GuiTexture(loc, x, y, x + w, y + h);
    }

    public static GuiTexture create(VLID loc, int x, int y, int w, int h, int textureWidth, int textureHeight) {
        return new GuiTexture(loc, x, y, x + w, y + h);
    }
}

