/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.container;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.base.ElementPosition;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;

public abstract class ScissorContainerElement
extends FixedContainerElement {
    protected int xScroll = 0;
    protected int yScroll = 0;
    protected int xScrollMin = 0;
    protected int xScrollMax = 0;
    protected int yScrollMin = 0;
    protected int yScrollMax = 0;

    public ScissorContainerElement(String id, int xSize, int ySize) {
        super(id, xSize, ySize);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.guiScissorStart(this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY());
        GuiUtils.drawBackground(this.elementsList, mouseX, mouseY, partialTicks, this);
        GuiUtils.guiScissorEnd();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        GuiUtils.guiScissorStart(this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY());
        GuiUtils.drawForeground(this.elementsList, mouseX, mouseY, this);
        GuiUtils.guiScissorEnd();
    }

    @Override
    public int getContainerOffsetX(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return ((ElementPosition)this.elements.get(ele)).getX() - this.xScroll;
        }
        return -this.xScroll;
    }

    @Override
    public int getContainerOffsetY(IElement ele) {
        if (this.elements.containsKey(ele)) {
            return ((ElementPosition)this.elements.get(ele)).getY() - this.yScroll;
        }
        return -this.yScroll;
    }

    public void resetScroll() {
        this.xScroll = 0;
        this.yScroll = 0;
    }

    public void setYScroll(int amt) {
        this.yScroll = MathUtil.clamp(amt, this.yScrollMin, this.yScrollMax);
    }

    public void setXScroll(int amt) {
        this.xScroll = MathUtil.clamp(amt, this.xScrollMin, this.xScrollMax);
    }

    public void addYScroll(int amt) {
        this.yScroll = MathUtil.clamp(this.yScroll + amt, this.yScrollMin, this.yScrollMax);
    }

    public void addXScroll(int amt) {
        this.xScroll = MathUtil.clamp(this.xScroll + amt, this.xScrollMin, this.xScrollMax);
    }

    public void setScrollMin(int xScrollMin, int yScrollMin) {
        this.xScrollMin = xScrollMin;
        this.yScrollMin = yScrollMin;
    }

    public void setScrollMax(int xScrollMax, int yScrollMax) {
        this.xScrollMax = xScrollMax;
        this.yScrollMax = yScrollMax;
    }

    public float getZoomDiv() {
        return 10.0f;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        System.out.println(key);
        switch (key) {
            case 87: {
                this.addYScroll(-10);
                break;
            }
            case 83: {
                this.addYScroll(10);
                break;
            }
            case 65: {
                this.addXScroll(-10);
                break;
            }
            case 68: {
                this.addXScroll(10);
            }
        }
        return GuiUtils.keyPressedCheckAll(this.getElementList(), key, scanCode, modifiers, this);
    }
}

