/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.button;

import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementFocusable;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementInput;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.button.base.ButtonState;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.util.client.TextComponentUtil;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public abstract class ButtonElement
extends VLElement
implements IElementDraw,
IElementDrawTooltip,
IElementInput,
IElementFocusable,
IElementThemeListener {
    protected QuickTooltips.List tooltips = new QuickTooltips.List();
    protected List<String> tooltipsConverted;
    protected int xSize;
    protected int ySize;
    protected boolean drawToolTip = true;
    protected boolean enabled = true;
    protected boolean selected = false;
    protected Screen screen;

    public ButtonElement(String id, int xSize, int ySize) {
        super(id);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public boolean emouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.livesOutsideContainer()) {
            return GuiUtils.withinBox((int)mouseX, (int)mouseY, this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY());
        }
        return this.withinBoxAndGui((int)mouseX, (int)mouseY, this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY());
    }

    @Override
    public boolean emouseReleased(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    @Override
    public boolean emouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXScroll, double mouseYScroll) {
        return false;
    }

    @Override
    public boolean emouseScrolled(double mouseX, double mouseY, double scrolled) {
        return false;
    }

    @Override
    public boolean ekeyPressed(int key, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean ekeyReleased(int key, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean echarTyped(char ch, int modifiers) {
        return false;
    }

    @Override
    public void onFocusChanged(boolean focused) {
        this.selected = focused;
    }

    @Override
    public boolean canCurrentlyFocus() {
        return true;
    }

    public void setEnabled(boolean opt) {
        this.enabled = opt;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void addToolTip(ITextComponent tooltip) {
        this.tooltips.add(tooltip);
    }

    public void setToolTipList(List<ITextComponent> toolTips) {
        this.tooltips = new QuickTooltips.List(toolTips);
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        if (!this.drawToolTip) {
            return;
        }
        int ttx = mouseX - this.getContainer().getActualX();
        int tty = mouseY - this.getContainer().getActualY();
        Screen s = this.getContainer().getGui();
        if (this.tooltipsConverted == null) {
            this.tooltipsConverted = TextComponentUtil.convertToFormatted(this.tooltips.build());
        }
        GuiUtils.withinEither(this::livesOutsideContainer, mouseX, mouseY, this, () -> s.renderTooltip(this.tooltipsConverted, mouseX, mouseY));
    }

    @Override
    public void drawBackground(int mx, int my, float pt) {
        if (this.enabled) {
            if (this.selected) {
                this.drawButtonStateBackground(ButtonState.SELECTED, mx, my, pt);
            } else {
                GuiUtils.withinEitherElse(this::livesOutsideContainer, mx, my, this, () -> this.drawButtonStateBackground(ButtonState.HOVER, mx, my, pt), () -> this.drawButtonStateBackground(ButtonState.ENABLED, mx, my, pt));
            }
        } else {
            this.drawButtonStateBackground(ButtonState.DISABLED, mx, my, pt);
        }
    }

    @Override
    public void drawForeground(int mx, int my) {
        if (this.enabled) {
            if (this.selected) {
                this.drawButtonStateForeground(ButtonState.SELECTED, mx, my);
            } else {
                GuiUtils.withinEitherElse(this::livesOutsideContainer, mx, my, this, () -> this.drawButtonStateForeground(ButtonState.HOVER, mx, my), () -> this.drawButtonStateForeground(ButtonState.ENABLED, mx, my));
            }
        } else {
            this.drawButtonStateForeground(ButtonState.DISABLED, mx, my);
        }
    }

    protected abstract void drawButtonStateBackground(ButtonState var1, int var2, int var3, float var4);

    protected abstract void drawButtonStateForeground(ButtonState var1, int var2, int var3);
}

