/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.valkyrieofnight.vlib.core.io.datapack.IDataRegistryReloader;
import com.valkyrieofnight.vlib.core.util.modloader.forge.IReloadListener;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public abstract class JsonDataLoader<DATA_TYPE, REGISTRY extends IDataRegistryReloader<DATA_TYPE>>
implements IReloadListener {
    private Gson gson;
    private String modid;
    private String folder;
    private String fileExtension;
    private REGISTRY registry;
    private final Class<DATA_TYPE> dataClass;

    public JsonDataLoader(String modid, String dataFolder, Gson gson, Class<DATA_TYPE> dataClass, REGISTRY registry) {
        this.modid = modid;
        this.folder = dataFolder;
        this.fileExtension = ".json";
        this.gson = gson;
        this.dataClass = dataClass;
        this.registry = registry;
    }

    @Override
    public void resourceManagerReload(@Nonnull IResourceManager resourceManager) {
        System.out.println("resourceManagerReload");
        this.load(resourceManager);
    }

    private void load(IResourceManager resourceManager) {
        HashMap<VLID, Object> loading = new HashMap<VLID, Object>();
        String location = this.modid + "/" + this.folder;
        for (ResourceLocation file : resourceManager.func_199003_a(location, f -> f.endsWith(this.fileExtension))) {
            System.out.println("Filez: " + file);
            VLID id = new VLID(file.func_110624_b(), file.func_110623_a().substring(location.length() + 1, file.func_110623_a().length() - this.fileExtension.length()));
            try {
                for (IResource resource : resourceManager.func_199004_b(file)) {
                    Object data;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_199027_b()));
                        data = this.gson.fromJson((Reader)reader, this.dataClass);
                    }
                    catch (JsonParseException ex) {
                        ex.printStackTrace();
                        continue;
                    }
                    loading.merge(id, data, (arg_0, arg_1) -> this.registry.merge(arg_0, arg_1));
                    IOUtils.closeQuietly((Closeable)resource);
                }
            }
            catch (IOException e) {
                this.handleException(id, e);
            }
        }
        this.registry.reloadData(loading);
    }

    protected abstract void handleException(VLID var1, Exception var2);
}

