/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.network.packet.SetSlotLarge;
import org.cyclops.colossalchests.network.packet.WindowItemsFragmentPacket;
import org.cyclops.cyclopscore.inventory.LargeInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.PacketBase;

@ChestContainer(isLargeChest=true)
public class ContainerColossalChest
extends ScrollingInventoryContainer<Slot> {
    private static final int INVENTORY_OFFSET_X = 9;
    private static final int INVENTORY_OFFSET_Y = 112;
    private static final int CHEST_INVENTORY_OFFSET_X = 9;
    private static final int CHEST_INVENTORY_OFFSET_Y = 18;
    public static final int CHEST_INVENTORY_ROWS = 5;
    public static final int CHEST_INVENTORY_COLUMNS = 9;
    private final List<Slot> chestSlots = Lists.newArrayListWithCapacity((int)this.getSizeInventory());
    private final NonNullList<ItemStack> inventoryItemStacks = NonNullList.func_191197_a((int)this.getSizeInventory(), (Object)ItemStack.field_190927_a);
    private int lastInventoryState = -2;
    private boolean firstDetectionCheck = true;

    public ContainerColossalChest(int id, PlayerInventory playerInventory, PacketBuffer data) {
        this(id, playerInventory, (IInventory)new LargeInventory(data.readInt(), 64));
    }

    public ContainerColossalChest(int id, PlayerInventory playerInventory, IInventory inventory) {
        super(RegistryEntries.CONTAINER_COLOSSAL_CHEST, id, playerInventory, inventory, Collections.emptyList(), (item, pattern) -> true);
        this.addChestSlots(this.getSizeInventory() / 9, 9);
        this.addPlayerInventory(playerInventory, 9, 112);
        this.updateFilter("");
    }

    protected List<Slot> getUnfilteredItems() {
        return this.chestSlots;
    }

    protected void addChestSlots(int rows, int columns) {
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = this.makeSlot(this.inventory, column + row * columns, 9 + column * 18, 18 + row * 18);
                this.func_75146_a(slot);
                this.chestSlots.add(slot);
            }
        }
    }

    protected Slot makeSlot(IInventory inventory, int index, int row, int column) {
        return new SlotExtended(inventory, index, row, column);
    }

    public int getColumns() {
        return 9;
    }

    public int getPageSize() {
        return 5;
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        ContainerColossalChest.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerColossalChest.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected void enableSlot(int slotIndex, int row, int column) {
        Slot slot = this.func_75139_a(slotIndex);
        ContainerColossalChest.setSlotPosX((Slot)slot, (int)(9 + column * 18));
        ContainerColossalChest.setSlotPosY((Slot)slot, (int)(18 + row * 18));
    }

    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
        super.onScroll(firstRow);
    }

    protected void enableElementAt(int visibleIndex, int elementIndex, Slot element) {
        super.enableElementAt(visibleIndex, elementIndex, (Object)element);
        int column = visibleIndex % this.getColumns();
        int row = (visibleIndex - column) / this.getColumns();
        this.enableSlot(elementIndex, row, column);
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        if (listener instanceof ServerPlayerEntity) {
            this.updateCraftingInventory((ServerPlayerEntity)listener, (List<ItemStack>)this.func_75138_a());
        } else {
            listener.func_71110_a((Container)this, this.func_75138_a());
        }
        this.func_75142_b();
    }

    public void func_75142_b() {
        int newState = ((SimpleInventory)this.inventory).getState();
        if (this.lastInventoryState != newState) {
            this.lastInventoryState = newState;
            this.detectAndSendChangesOverride();
        }
    }

    protected void detectAndSendChangesOverride() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.inventoryItemStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
            this.inventoryItemStacks.set(i, (Object)itemstack1);
            if (this.firstDetectionCheck) continue;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                IContainerListener listener = (IContainerListener)this.field_75149_d.get(j);
                if (listener instanceof ServerPlayerEntity) {
                    this.sendSlotContentsToPlayer((ServerPlayerEntity)listener, (Container)this, i, itemstack1);
                    continue;
                }
                listener.func_71111_a((Container)this, i, itemstack1);
            }
        }
        this.firstDetectionCheck = false;
    }

    protected void sendSlotContentsToPlayer(ServerPlayerEntity player, Container containerToSend, int slotInd, ItemStack stack) {
        if (!(containerToSend.func_75139_a(slotInd) instanceof CraftingResultSlot) && !player.field_71137_h) {
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new SetSlotLarge(containerToSend.field_75152_c, slotInd, stack), player);
        }
    }

    protected int getTagSize(INBT tag) {
        if (tag instanceof NumberNBT || tag instanceof EndNBT) {
            return 1;
        }
        if (tag instanceof CompoundNBT) {
            CompoundNBT compound = (CompoundNBT)tag;
            int size = 0;
            for (String key : compound.func_150296_c()) {
                size += this.getTagSize(compound.func_74781_a(key));
            }
            return size;
        }
        if (tag instanceof ByteArrayNBT) {
            return ((ByteArrayNBT)tag).func_150292_c().length;
        }
        if (tag instanceof IntArrayNBT) {
            return ((IntArrayNBT)tag).func_150302_c().length * 32;
        }
        if (tag instanceof ListNBT) {
            ListNBT list = (ListNBT)tag;
            int size = 0;
            for (int i = 0; i < list.size(); ++i) {
                size += this.getTagSize(list.get(i));
            }
            return size;
        }
        if (tag instanceof StringNBT) {
            try {
                return ((StringNBT)tag).func_150285_a_().getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return tag.toString().length();
    }

    public void updateCraftingInventory(ServerPlayerEntity player, List<ItemStack> allItems) {
        int maxBufferSize = GeneralConfig.maxPacketBufferSize;
        ServerPlayNetHandler playerNetServerHandler = player.field_71135_a;
        CompoundNBT sendBuffer = new CompoundNBT();
        ListNBT sendList = new ListNBT();
        sendBuffer.func_218657_a("stacks", (INBT)sendList);
        int i = 0;
        int bufferSize = 0;
        boolean sent = false;
        for (ItemStack itemStack : allItems) {
            if (itemStack != null) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74768_a("slot", i);
                tag.func_218657_a("stack", (INBT)itemStack.serializeNBT());
                int tagSize = this.getTagSize((INBT)tag);
                if (bufferSize + tagSize + 100 < maxBufferSize) {
                    sendList.add((Object)tag);
                    bufferSize += tagSize;
                } else {
                    ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new WindowItemsFragmentPacket(this.field_75152_c, sendBuffer), player);
                    sendBuffer = new CompoundNBT();
                    sendList = new ListNBT();
                    sendList.add((Object)tag);
                    sendBuffer.func_218657_a("stacks", (INBT)sendList);
                    bufferSize = tagSize;
                }
            }
            ++i;
        }
        if (sendList.size() > 0) {
            ColossalChests._instance.getPacketHandler().sendToPlayer((PacketBase)new WindowItemsFragmentPacket(this.field_75152_c, sendBuffer), player);
        }
        playerNetServerHandler.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSelection() {
        try {
            int i;
            HashMap selection = Maps.newHashMap();
            ArrayList chest = Lists.newArrayList();
            ArrayList playerInventory = Lists.newArrayList();
            for (i = 0; i < this.getSizeInventory(); ++i) {
                chest.add(this.func_75139_a(i));
            }
            for (i = this.getSizeInventory(); i < this.getSizeInventory() + this.player.field_71071_by.field_70462_a.size(); ++i) {
                playerInventory.add(this.func_75139_a(i));
            }
            selection.put(ContainerSection.CHEST, chest);
            selection.put(ContainerSection.INVENTORY, playerInventory);
            return selection;
        }
        catch (RuntimeException e) {
            System.out.println("Size inv " + this.getSizeInventory());
            System.out.println("Player size inv " + this.player.field_71071_by.field_70462_a.size());
            System.out.println("Available slots " + this.field_75151_b.size());
            throw e;
        }
    }
}

