/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.inventory.container.ContainerColossalChest;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.CubeSizeValidator;
import org.cyclops.cyclopscore.block.multi.ExactBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.MaximumSizeValidator;
import org.cyclops.cyclopscore.block.multi.MinimumSizeValidator;

public class ChestMaterial
extends ForgeRegistryEntry<ChestMaterial> {
    public static final List<ChestMaterial> VALUES = Lists.newArrayList();
    public static final Map<String, ChestMaterial> KEYED_VALUES = Maps.newHashMap();
    public static final ChestMaterial WOOD = new ChestMaterial("wood", 1.0);
    public static final ChestMaterial COPPER = new ChestMaterial("copper", 1.666);
    public static final ChestMaterial IRON = new ChestMaterial("iron", 2.0);
    public static final ChestMaterial SILVER = new ChestMaterial("silver", 2.666);
    public static final ChestMaterial GOLD = new ChestMaterial("gold", 3.0);
    public static final ChestMaterial DIAMOND = new ChestMaterial("diamond", 4.0);
    public static final ChestMaterial OBSIDIAN = new ChestMaterial("obsidian", 4.0);
    private final String name;
    private final double inventoryMultiplier;
    private final int index;
    private ColossalChest blockCore;
    private Interface blockInterface;
    private ChestWall blockWall;
    private CubeDetector chestDetector = null;
    private ContainerType<ContainerColossalChest> container;

    public ChestMaterial(String name, double inventoryMultiplier) {
        this.name = name;
        this.inventoryMultiplier = inventoryMultiplier;
        this.index = VALUES.size();
        VALUES.add(this);
        KEYED_VALUES.put(this.getName(), this);
    }

    public static ChestMaterial valueOf(String materialString) {
        return KEYED_VALUES.get(materialString.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public double getInventoryMultiplier() {
        return this.inventoryMultiplier;
    }

    public String getUnlocalizedName() {
        return "material.colossalchests." + this.getName();
    }

    public boolean isExplosionResistant() {
        return this == OBSIDIAN;
    }

    public int ordinal() {
        return this.index;
    }

    public ColossalChest getBlockCore() {
        return this.blockCore;
    }

    public void setBlockCore(ColossalChest blockCore) {
        if (this.blockCore != null) {
            throw new IllegalStateException("Tried registering multiple core blocks for " + this.getName());
        }
        this.blockCore = blockCore;
    }

    public Interface getBlockInterface() {
        return this.blockInterface;
    }

    public void setBlockInterface(Interface blockInterface) {
        if (this.blockInterface != null) {
            throw new IllegalStateException("Tried registering multiple core blocks for " + this.getName());
        }
        this.blockInterface = blockInterface;
    }

    public ChestWall getBlockWall() {
        return this.blockWall;
    }

    public void setBlockWall(ChestWall blockWall) {
        if (this.blockWall != null) {
            throw new IllegalStateException("Tried registering multiple core blocks for " + this.getName());
        }
        this.blockWall = blockWall;
    }

    public void setContainer(ContainerType<ContainerColossalChest> container) {
        if (this.container != null) {
            throw new IllegalStateException("Tried registering multiple containers for " + this.getName());
        }
        this.container = container;
    }

    public ContainerType<ContainerColossalChest> getContainer() {
        return this.container;
    }

    public CubeDetector getChestDetector() {
        if (this.chestDetector == null) {
            this.chestDetector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)this.getBlockWall()), new AllowedBlock((Block)this.getBlockCore()).addCountValidator((IBlockCountValidator)new ExactBlockCountValidator(1)), new AllowedBlock((Block)this.getBlockInterface())}, (List)Lists.newArrayList((Object[])new Block[]{this.getBlockCore(), this.getBlockWall(), this.getBlockInterface()})).addSizeValidator((ISizeValidator)new MinimumSizeValidator(new Vec3i(1, 1, 1))).addSizeValidator((ISizeValidator)new CubeSizeValidator()).addSizeValidator((ISizeValidator)new MaximumSizeValidator(TileColossalChest.getMaxSize()){

                public Vec3i getMaximumSize() {
                    return TileColossalChest.getMaxSize();
                }
            });
        }
        return this.chestDetector;
    }
}

