/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.impl.map.MapRegion;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;

public class MapChunk {
    public final MapRegion region;
    public final XZ pos;
    public boolean loaded;
    public boolean weakUpdate;

    public static int index(int x, int z) {
        return (x & 0xF) + (z & 0xF) * 16;
    }

    MapChunk(MapRegion r, XZ p) {
        this.region = r;
        this.pos = p;
        this.loaded = false;
        this.weakUpdate = false;
    }

    public int getHeight(int x, int z) {
        return this.region.getImage().getRGB(this.pos.x * 16 + x, this.pos.z * 16 + z) >> 24 & 0xFF;
    }

    public int getRGB(int x, int z) {
        return 0xFF000000 | this.region.getImage().getRGB(this.pos.x * 16 + x, this.pos.z * 16 + z);
    }

    public boolean setHRGB(int x, int z, int hrgb) {
        int c = this.region.getImage().getRGB(this.pos.x * 16 + x, this.pos.z * 16 + z);
        if (c != hrgb) {
            this.region.getImage().setRGB(this.pos.x * 16 + x, this.pos.z * 16 + z, hrgb);
            this.region.save();
            return true;
        }
        return false;
    }

    public static int getHeight(@Nullable IChunk chunk, BlockPos.Mutable currentBlockPos, int blockX, int blockZ, int topY) {
        if (topY == -1 || chunk == null || chunk.getWorldForge() == null) {
            return -1;
        }
        for (int by = topY; by > 0; --by) {
            currentBlockPos.func_181079_c(blockX, by, blockZ);
            BlockState state = chunk.func_180495_p((BlockPos)currentBlockPos);
            if (by == topY || state.func_177230_c() == Blocks.field_150357_h) {
                while (by > 0) {
                    currentBlockPos.func_181079_c(blockX, by, blockZ);
                    state = chunk.func_180495_p((BlockPos)currentBlockPos);
                    if (state.func_177230_c().isAir(state, (IBlockReader)chunk.getWorldForge(), (BlockPos)currentBlockPos)) break;
                    --by;
                }
            }
            if (MapChunk.skipBlock(state, chunk.getWorldForge(), (BlockPos)currentBlockPos)) continue;
            return by;
        }
        return -1;
    }

    public static boolean skipBlock(BlockState state, IWorld world, BlockPos pos) {
        Block b = state.func_177230_c();
        if (b == Blocks.field_196804_gh || b == Blocks.field_196805_gi || b instanceof TallGrassBlock) {
            return true;
        }
        if (b instanceof FireBlock) {
            return true;
        }
        if (b instanceof AbstractButtonBlock) {
            return true;
        }
        if (b instanceof TorchBlock) {
            return !(b instanceof RedstoneTorchBlock);
        }
        return b.isAir(state, (IBlockReader)world, pos);
    }

    public XZ getActualPos() {
        return XZ.of((this.region.pos.x << 5) + this.pos.x, (this.region.pos.z << 5) + this.pos.z);
    }
}

