/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl.map;

import com.feed_the_beast.mods.ftbchunks.FoliageColorLoader;
import com.feed_the_beast.mods.ftbchunks.GrassColorLoader;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapColorGetter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DarkForestBiome;
import net.minecraft.world.biome.DarkForestHillsBiome;
import net.minecraft.world.biome.SwampBiome;
import net.minecraft.world.biome.SwampHillsBiome;

public enum ColorBlend {
    WATER((w, p) -> w.func_226691_t_(p).func_185361_o()),
    GRASS((w, p) -> {
        if (GrassColorLoader.map.length != 65536) {
            return -8670622;
        }
        Biome biome = w.func_226691_t_(p);
        if (biome instanceof SwampBiome || biome instanceof SwampHillsBiome) {
            double d0 = Biome.field_180281_af.func_215464_a(((double)p.func_177958_n() + 0.5) * 0.0225, ((double)p.func_177952_p() + 0.5) * 0.0225, false);
            return d0 < -0.1 ? 5011004 : 6975545;
        }
        float temperature = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
        float humidity = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f) * temperature;
        int i = (int)((1.0f - temperature) * 255.0f);
        int j = (int)((1.0f - humidity) * 255.0f);
        int col = GrassColorLoader.map[j << 8 | i];
        if (biome instanceof DarkForestBiome || biome instanceof DarkForestHillsBiome) {
            return (col & 0xFEFEFE) + 2634762 >> 1;
        }
        return col;
    }),
    FOLIAGE((w, p) -> {
        if (FoliageColorLoader.map.length != 65536) {
            return -11167436;
        }
        Biome biome = w.func_226691_t_(p);
        if (biome instanceof SwampBiome || biome instanceof SwampHillsBiome) {
            return 6975545;
        }
        float temperature = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
        float humidity = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f) * temperature;
        int i = (int)((1.0f - temperature) * 255.0f);
        int j = (int)((1.0f - humidity) * 255.0f);
        return FoliageColorLoader.map[j << 8 | i];
    });

    public final MapColorGetter colorGetter;

    private ColorBlend(MapColorGetter c) {
        this.colorGetter = c;
    }

    public int blend(World world, BlockPos p, int radius) {
        return ColorBlend.blend(world, p, radius, this.colorGetter);
    }

    public static int blend(World world, BlockPos p, int radius, MapColorGetter colorGetter) {
        int j = (radius * 2 + 1) * (radius * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        CubeCoordinateIterator cci = new CubeCoordinateIterator(p.func_177958_n() - radius, p.func_177956_o(), p.func_177952_p() - radius, p.func_177958_n() + radius, p.func_177956_o(), p.func_177952_p() + radius);
        BlockPos.Mutable pm = new BlockPos.Mutable();
        while (cci.func_218301_a()) {
            pm.func_181079_c(cci.func_218304_b(), cci.func_218302_c(), cci.func_218303_d());
            int j1 = colorGetter.getColor(world, (BlockPos)pm);
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public static int addBrightness(int c, float f) {
        float r = (float)(c >> 16 & 0xFF) / 255.0f + f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f + f;
        float b = (float)(c >> 0 & 0xFF) / 255.0f + f;
        int ri = MathHelper.func_76125_a((int)((int)(r * 255.0f)), (int)0, (int)255);
        int gi = MathHelper.func_76125_a((int)((int)(g * 255.0f)), (int)0, (int)255);
        int bi = MathHelper.func_76125_a((int)((int)(b * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | ri << 16 | gi << 8 | bi;
    }
}

