/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.impl;

import com.feed_the_beast.mods.ftbchunks.FTBChunks;
import com.feed_the_beast.mods.ftbchunks.api.ChunkDimPos;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunk;
import com.feed_the_beast.mods.ftbchunks.api.ClaimedChunkManager;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkImpl;
import com.feed_the_beast.mods.ftbchunks.impl.ClaimedChunkPlayerDataImpl;
import com.feed_the_beast.mods.ftbchunks.impl.FTBChunksAPIImpl;
import com.feed_the_beast.mods.ftbchunks.impl.KnownFakePlayer;
import com.feed_the_beast.mods.ftbchunks.impl.map.MapManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClaimedChunkManagerImpl
implements ClaimedChunkManager {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public final MinecraftServer server;
    public UUID serverId;
    public final Map<UUID, ClaimedChunkPlayerDataImpl> playerData;
    public final Map<ChunkDimPos, ClaimedChunkImpl> claimedChunks;
    public final Map<UUID, KnownFakePlayer> knownFakePlayers;
    public boolean saveFakePlayers;
    public Path dataDirectory;
    public Path localDirectory;
    public MapManager map;
    private boolean inited;

    public ClaimedChunkManagerImpl(MinecraftServer s) {
        this.server = s;
        this.serverId = UUID.randomUUID();
        this.playerData = new HashMap<UUID, ClaimedChunkPlayerDataImpl>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunkImpl>();
        this.knownFakePlayers = new HashMap<UUID, KnownFakePlayer>();
        this.saveFakePlayers = false;
        this.map = new MapManager(this);
        this.inited = false;
    }

    public void init(ServerWorld world) {
        JsonObject json3;
        Object object;
        if (this.inited) {
            return;
        }
        this.inited = true;
        long nanos = System.nanoTime();
        this.dataDirectory = world.func_217485_w().func_75765_b().toPath().resolve("data/ftbchunks");
        this.localDirectory = FMLPaths.GAMEDIR.get().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(this.localDirectory, new LinkOption[0])) {
                Files.createDirectories(this.localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Path infoFile = this.dataDirectory.resolve("info.json");
        if (Files.exists(infoFile, new LinkOption[0])) {
            try {
                BufferedReader reader = Files.newBufferedReader(infoFile);
                object = null;
                try {
                    json3 = (JsonObject)new GsonBuilder().disableHtmlEscaping().create().fromJson((Reader)reader, JsonObject.class);
                    this.serverId = UUID.fromString(json3.get("id").getAsString());
                }
                catch (Throwable json2) {
                    object = json2;
                    throw json2;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable json2) {
                                ((Throwable)object).addSuppressed(json2);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                BufferedWriter writer = Files.newBufferedWriter(infoFile, new OpenOption[0]);
                object = null;
                try {
                    json3 = new JsonObject();
                    json3.addProperty("id", this.serverId.toString());
                    new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((JsonElement)json3, (Appendable)writer);
                }
                catch (Throwable json3) {
                    object = json3;
                    throw json3;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                ((Writer)writer).close();
                            }
                            catch (Throwable json3) {
                                ((Throwable)object).addSuppressed(json3);
                            }
                        } else {
                            ((Writer)writer).close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loadPlayerData();
        int forceLoaded = 0;
        for (ClaimedChunkImpl chunk : this.claimedChunks.values()) {
            if (!chunk.isForceLoaded()) continue;
            ++forceLoaded;
            chunk.postSetForceLoaded(true);
        }
        FTBChunks.LOGGER.info("Server " + this.serverId + ": Loaded " + this.claimedChunks.size() + " chunks (" + forceLoaded + " force loaded) from " + this.playerData.size() + " players in " + (double)(System.nanoTime() - nanos) / 1000000.0 + "ms");
        this.getServerData();
    }

    public void serverSaved() {
        for (ClaimedChunkPlayerDataImpl claimedChunkPlayerDataImpl : this.playerData.values()) {
            if (!claimedChunkPlayerDataImpl.shouldSave) continue;
            try (BufferedWriter writer = Files.newBufferedWriter(claimedChunkPlayerDataImpl.file, new OpenOption[0]);){
                GSON.toJson((JsonElement)claimedChunkPlayerDataImpl.toJson(), (Appendable)writer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            claimedChunkPlayerDataImpl.shouldSave = false;
        }
        if (this.saveFakePlayers) {
            this.saveFakePlayers = false;
            JsonArray array = new JsonArray();
            for (KnownFakePlayer p : this.knownFakePlayers.values()) {
                JsonObject json = new JsonObject();
                json.addProperty("uuid", UUIDTypeAdapter.fromUUID((UUID)p.uuid));
                json.addProperty("name", p.name);
                json.addProperty("banned", Boolean.valueOf(p.banned));
                array.add((JsonElement)json);
            }
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(this.dataDirectory.resolve("known_fake_players.json"), new OpenOption[0]);){
                GSON.toJson((JsonElement)array, (Appendable)bufferedWriter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void loadPlayerData() {
        try {
            Files.list(this.dataDirectory).filter(path -> path.getFileName().toString().endsWith(".json") && !path.getFileName().toString().equals("info.json") && !path.getFileName().toString().equals("known_fake_players.json")).forEach(path -> {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                    if (json == null || !json.has("name") || !json.has("uuid")) {
                        return;
                    }
                    UUID id = UUIDTypeAdapter.fromString((String)json.get("uuid").getAsString());
                    ClaimedChunkPlayerDataImpl data = new ClaimedChunkPlayerDataImpl(this, (Path)path, id);
                    data.fromJson(json);
                    this.playerData.put(id, data);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Path knownFakePlayersFile = this.dataDirectory.resolve("known_fake_players.json");
        if (Files.exists(knownFakePlayersFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(knownFakePlayersFile);){
                for (JsonElement e : (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class)) {
                    JsonObject json = e.getAsJsonObject();
                    UUID uuid = UUIDTypeAdapter.fromString((String)json.get("uuid").getAsString());
                    String name = json.get("name").getAsString();
                    boolean banned = json.get("banned").getAsBoolean();
                    this.knownFakePlayers.put(uuid, new KnownFakePlayer(uuid, name, banned));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    @Override
    public UUID getServerId() {
        return this.serverId;
    }

    @Override
    public ClaimedChunkPlayerDataImpl getData(UUID id, String name) {
        ClaimedChunkPlayerDataImpl data = this.playerData.get(id);
        if (data == null) {
            data = new ClaimedChunkPlayerDataImpl(this, this.dataDirectory.resolve(UUIDTypeAdapter.fromUUID((UUID)id) + "-" + name + ".json"), id);
            data.profile = new GameProfile(id, name);
            this.playerData.put(id, data);
            data.save();
        }
        return data;
    }

    @Override
    public ClaimedChunkPlayerDataImpl getData(ServerPlayerEntity player) {
        return this.getData(player.func_110124_au(), player.func_146103_bH().getName());
    }

    @Override
    public ClaimedChunkPlayerDataImpl getServerData() {
        return this.getData(SERVER_PLAYER_ID, "Server");
    }

    @Override
    @Nullable
    public ClaimedChunkImpl getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    @Override
    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }

    public static String prettyTimeString(long seconds) {
        if (seconds <= 0L) {
            return "0 seconds";
        }
        StringBuilder builder = new StringBuilder();
        ClaimedChunkManagerImpl.prettyTimeString(builder, seconds, true);
        return builder.toString();
    }

    private static void prettyTimeString(StringBuilder builder, long seconds, boolean addAnother) {
        if (seconds <= 0L) {
            return;
        }
        if (!addAnother) {
            builder.append(" and ");
        }
        if (seconds < 60L) {
            builder.append(seconds);
            builder.append(seconds == 1L ? " second" : " seconds");
        } else if (seconds < 3600L) {
            builder.append(seconds / 60L);
            builder.append(seconds / 60L == 1L ? " minute" : " minutes");
            if (addAnother) {
                ClaimedChunkManagerImpl.prettyTimeString(builder, seconds % 60L, false);
            }
        } else if (seconds < 86400L) {
            builder.append(seconds / 3600L);
            builder.append(seconds / 3600L == 1L ? " hour" : " hours");
            if (addAnother) {
                ClaimedChunkManagerImpl.prettyTimeString(builder, seconds % 3600L, false);
            }
        } else {
            builder.append(seconds / 86400L);
            builder.append(seconds / 86400L == 1L ? " day" : " days");
            if (addAnother) {
                ClaimedChunkManagerImpl.prettyTimeString(builder, seconds % 86400L, false);
            }
        }
    }

    public void exportJson() {
        JsonObject json = new JsonObject();
        JsonObject playersJson = new JsonObject();
        for (ClaimedChunkPlayerDataImpl data : this.playerData.values()) {
            playersJson.add(data.getName(), (JsonElement)data.toJson());
        }
        json.add("players", (JsonElement)playersJson);
        try (BufferedWriter writer = Files.newBufferedWriter(this.localDirectory.resolve("all.json"), new OpenOption[0]);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exportSvg() {
        HashMap<DimensionType, ArrayList> chunkMap = new HashMap<DimensionType, ArrayList>();
        for (ClaimedChunk chunk : FTBChunksAPIImpl.manager.getAllClaimedChunks()) {
            chunkMap.computeIfAbsent(chunk.getPos().dimension, type -> new ArrayList()).add(chunk);
        }
        long sec = Instant.now().getEpochSecond();
        for (Map.Entry entry : chunkMap.entrySet()) {
            try {
                BufferedWriter writer = Files.newBufferedWriter(this.localDirectory.resolve(((DimensionType)entry.getKey()).getRegistryName().toString().replaceAll("\\W", "_") + ".svg"), new OpenOption[0]);
                Throwable throwable = null;
                try {
                    DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element svg = document.createElement("svg");
                    document.appendChild(svg);
                    svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
                    svg.setAttribute("version", "1.1");
                    Element style = document.createElement("style");
                    StringBuilder sb = new StringBuilder();
                    sb.append("text{font-size:4px;dominant-baseline:hanging;}");
                    sb.append("rect{width:32px;height:32px;stroke-width:0.75px;stroke:#000000;}");
                    sb.append(".fl{stroke:#FF0000;}");
                    style.appendChild(document.createTextNode(sb.toString()));
                    svg.appendChild(style);
                    int minX = Integer.MAX_VALUE;
                    int minZ = Integer.MAX_VALUE;
                    int maxX = Integer.MIN_VALUE;
                    int maxZ = Integer.MIN_VALUE;
                    for (ClaimedChunk chunk : (ArrayList)entry.getValue()) {
                        minX = Math.min(minX, chunk.getPos().x);
                        minZ = Math.min(minZ, chunk.getPos().z);
                        maxX = Math.max(maxX, chunk.getPos().x);
                        maxZ = Math.max(maxZ, chunk.getPos().z);
                    }
                    svg.setAttribute("width", Integer.toString((maxX - minX + 3) * 33) + 2);
                    svg.setAttribute("height", Integer.toString((maxZ - minZ + 3) * 33) + 2);
                    for (ClaimedChunk chunk : (ArrayList)entry.getValue()) {
                        int x = (chunk.getPos().x - minX + 1) * 33 + 1;
                        int z = (chunk.getPos().z - minZ + 1) * 33 + 1;
                        Element c = document.createElement("rect");
                        c.setAttribute("x", Integer.toString(x));
                        c.setAttribute("y", Integer.toString(z));
                        c.setAttribute("fill", String.format("#%06X", 0xFFFFFF & chunk.getColor()));
                        StringBuilder title = new StringBuilder();
                        title.append("Claimed: ").append(ClaimedChunkManagerImpl.prettyTimeString(sec - chunk.getTimeClaimed().getEpochSecond())).append(" ago");
                        String group = chunk.getGroupID();
                        if (!group.isEmpty()) {
                            title.append("\r\nGroup: ").append(group);
                        }
                        if (chunk.isForceLoaded()) {
                            c.setAttribute("class", "fl");
                            title.append("\r\nForce Loaded");
                        }
                        svg.appendChild(c);
                        Element t = document.createElement("title");
                        t.appendChild(document.createTextNode(title.toString()));
                        c.appendChild(t);
                        Element n = document.createElement("text");
                        n.setAttribute("x", Integer.toString(x + 1));
                        n.setAttribute("y", Integer.toString(z + 1));
                        n.appendChild(document.createTextNode(chunk.getPlayerData().getName()));
                        svg.appendChild(n);
                        Element cx = document.createElement("text");
                        cx.setAttribute("x", Integer.toString(x + 1));
                        cx.setAttribute("y", Integer.toString(z + 6));
                        cx.appendChild(document.createTextNode("X: " + ((chunk.getPos().x << 4) + 8)));
                        svg.appendChild(cx);
                        Element cz = document.createElement("text");
                        cz.setAttribute("x", Integer.toString(x + 1));
                        cz.setAttribute("y", Integer.toString(z + 11));
                        cz.appendChild(document.createTextNode("Z: " + ((chunk.getPos().z << 4) + 8)));
                        svg.appendChild(cz);
                    }
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    DOMSource domSource = new DOMSource(document);
                    StreamResult streamResult = new StreamResult(writer);
                    transformer.transform(domSource, streamResult);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

