/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbchunks.client;

import com.feed_the_beast.mods.ftbchunks.client.ChunkScreen;
import com.feed_the_beast.mods.ftbchunks.client.FTBChunksClientConfig;
import com.feed_the_beast.mods.ftbchunks.client.RegionMapPanel;
import com.feed_the_beast.mods.ftbchunks.client.RegionTextureData;
import com.feed_the_beast.mods.ftbchunks.client.map.ClientMapDimension;
import com.feed_the_beast.mods.ftbchunks.impl.map.XZ;
import com.feed_the_beast.mods.ftbchunks.net.FTBChunksNet;
import com.feed_the_beast.mods.ftbchunks.net.RequestPlayerListPacket;
import com.feed_the_beast.mods.ftbchunks.net.TeleportFromMapPacket;
import com.feed_the_beast.mods.ftbguilibrary.icon.Color4I;
import com.feed_the_beast.mods.ftbguilibrary.utils.Key;
import com.feed_the_beast.mods.ftbguilibrary.utils.MouseButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Button;
import com.feed_the_beast.mods.ftbguilibrary.widget.ColorWidget;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiBase;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import com.feed_the_beast.mods.ftbguilibrary.widget.Panel;
import com.feed_the_beast.mods.ftbguilibrary.widget.SimpleButton;
import com.feed_the_beast.mods.ftbguilibrary.widget.Theme;
import com.feed_the_beast.mods.ftbguilibrary.widget.Widget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LargeMapScreen
extends GuiBase {
    public Color4I backgroundColor = Color4I.rgb((int)0x202225);
    public RegionMapPanel regionPanel = new RegionMapPanel(this);
    public int zoom = 256;
    public final HashMap<XZ, RegionTextureData> regionTextures = new HashMap();
    public ClientMapDimension dimension = ClientMapDimension.current;
    public int scrollWidth = 0;
    public int scrollHeight = 0;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed = 0;
    public boolean movedToPlayer = false;
    public Button claimChunksButton;
    public Button dimensionButton;
    public Button waypointsButton;
    public Button settingsButton;
    public Button alliesButton;

    public LargeMapScreen() {
        this.regionPanel.setScrollX(0.0);
        this.regionPanel.setScrollY(0.0);
    }

    public int getRegionButtonSize() {
        return this.zoom * 2;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = up > 0.0 ? (this.zoom *= 2) : (this.zoom /= 2);
        this.zoom = MathHelper.func_76125_a((int)this.zoom, (int)1, (int)1024);
        if (this.zoom != z) {
            this.grabbed = 0;
            double sx = this.regionPanel.regionX;
            double sy = this.regionPanel.regionZ;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo(sx, sy);
            ObfuscationReflectionHelper.setPrivateValue(MouseHelper.class, (Object)Minecraft.func_71410_x().field_71417_B, (Object)true, (String)"field_198051_p");
            Minecraft.func_71410_x().field_71417_B.func_198032_j();
        }
    }

    public void onClosed() {
        super.onClosed();
        for (RegionTextureData data : this.regionTextures.values()) {
            data.release();
        }
        this.regionTextures.clear();
    }

    public void addWidgets() {
        this.add((Widget)this.regionPanel);
        this.add(new ColorWidget((Panel)this, this.backgroundColor.withAlpha(150), null).setPosAndSize(0, 0, 18, 37));
        this.add(new ColorWidget((Panel)this, this.backgroundColor.withAlpha(150), null).setPosAndSize(0, this.height - 38, 18, 38));
        this.claimChunksButton = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbchunks.gui.claimed_chunks", (Object[])new Object[0]), GuiIcons.MAP, (b, m) -> new ChunkScreen().openGui());
        this.add((Widget)this.claimChunksButton);
        this.settingsButton = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbchunks.gui.settings", (Object[])new Object[0]), GuiIcons.SETTINGS, (b, m) -> FTBChunksClientConfig.openSettings());
        this.add((Widget)this.settingsButton);
        this.alliesButton = new SimpleButton((Panel)this, I18n.func_135052_a((String)"ftbchunks.gui.allies", (Object[])new Object[0]), GuiIcons.FRIENDS, (b, m) -> FTBChunksNet.MAIN.sendToServer((Object)new RequestPlayerListPacket()));
        this.add((Widget)this.alliesButton);
        this.dimensionButton = new SimpleButton((Panel)this, this.dimension.directory.getFileName().toString(), GuiIcons.GLOBE, (b, m) -> {
            List types = Registry.field_212622_k.func_201756_e().filter(t -> {
                ResourceLocation id = DimensionType.func_212678_a((DimensionType)t);
                return id != null && Files.exists(this.dimension.manager.directory.resolve(id.func_110624_b() + "_" + id.func_110623_a()), new LinkOption[0]);
            }).collect(Collectors.toList());
            int i = types.indexOf(this.dimension.dimension);
            if (i != -1) {
                for (RegionTextureData data : this.regionTextures.values()) {
                    data.release();
                }
                this.regionTextures.clear();
                this.dimension = this.dimension.manager.getDimension((DimensionType)types.get((i + 1) % types.size()));
                this.refreshWidgets();
                this.movedToPlayer = false;
            }
        });
        this.add((Widget)this.dimensionButton);
    }

    public void alignWidgets() {
        this.claimChunksButton.setPosAndSize(1, 1, 16, 16);
        this.alliesButton.setPosAndSize(1, 19, 16, 16);
        this.settingsButton.setPosAndSize(1, this.height - 18, 16, 16);
        this.dimensionButton.setPosAndSize(1, this.height - 36, 16, 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft()) {
            this.prevMouseX = this.getMouseX();
            this.prevMouseY = this.getMouseY();
            return true;
        }
        return false;
    }

    public boolean keyPressed(Key key) {
        if (key.is(84)) {
            if (this.dimension == ClientMapDimension.current) {
                FTBChunksNet.MAIN.sendToServer((Object)new TeleportFromMapPacket(this.regionPanel.blockX, this.regionPanel.blockZ));
                this.closeGui(false);
            }
            return true;
        }
        if (key.is(87)) {
            return true;
        }
        if (key.is(32)) {
            this.movedToPlayer = false;
            return true;
        }
        return super.keyPressed(key);
    }

    public boolean drawDefaultBackground() {
        if (!this.movedToPlayer) {
            ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
            this.regionPanel.resetScroll();
            this.regionPanel.scrollTo((double)p.field_70176_ah / 32.0, (double)p.field_70164_aj / 32.0);
            this.movedToPlayer = true;
        }
        this.backgroundColor.draw(0, 0, this.width, this.height);
        return false;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.regionPanel.width) {
                this.regionPanel.setScrollX(Math.max(Math.min(this.regionPanel.getScrollX() + (double)(this.prevMouseX - mx), (double)(this.scrollWidth - this.regionPanel.width)), 0.0));
            }
            if (this.scrollHeight > this.regionPanel.height) {
                this.regionPanel.setScrollY(Math.max(Math.min(this.regionPanel.getScrollY() + (double)(this.prevMouseY - my), (double)(this.scrollHeight - this.regionPanel.height)), 0.0));
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
        if (this.scrollWidth <= this.regionPanel.width) {
            this.regionPanel.setScrollX((double)(this.scrollWidth - this.regionPanel.width) / 2.0);
        }
        if (this.scrollHeight <= this.regionPanel.height) {
            this.regionPanel.setScrollY((double)(this.scrollHeight - this.regionPanel.height) / 2.0);
        }
        GlStateManager.func_227621_I_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int r = 70;
        int g = 70;
        int b = 70;
        int a = 100;
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int s = this.getRegionButtonSize();
        double ox = -this.regionPanel.getScrollX() % (double)s;
        double oy = -this.regionPanel.getScrollY() % (double)s;
        for (int gx = 0; gx <= w / s + 1; ++gx) {
            buffer.func_225582_a_((double)x + ox + (double)(gx * s), (double)y, 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)x + ox + (double)(gx * s), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        }
        for (int gy = 0; gy <= h / s + 1; ++gy) {
            buffer.func_225582_a_((double)x, (double)y + oy + (double)(gy * s), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_225582_a_((double)(x + w), (double)y + oy + (double)(gy * s), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        String coords = "X: " + this.regionPanel.blockX + ", Z: " + this.regionPanel.blockZ;
        int coordsw = theme.getStringWidth(coords) / 2;
        this.backgroundColor.withAlpha(150).draw(x + (w - coordsw) / 2, y + h - 6, coordsw + 4, h);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)x + (float)(w - coordsw) / 2.0f + 2.0f), (float)(y + h - 5), (float)0.0f);
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        theme.drawString(coords, 0, 0, 2);
        RenderSystem.popMatrix();
    }
}

