/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BiomeInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.PredefinedCity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import org.apache.commons.lang3.tuple.Pair;

public class City {
    private static Map<ChunkCoord, PredefinedCity> predefinedCityMap = null;
    private static Map<ChunkCoord, PredefinedCity.PredefinedBuilding> predefinedBuildingMap = null;
    private static Map<ChunkCoord, PredefinedCity.PredefinedStreet> predefinedStreetMap = null;

    public static void cleanCache() {
        predefinedCityMap = null;
        predefinedBuildingMap = null;
        predefinedStreetMap = null;
    }

    public static PredefinedCity getPredefinedCity(int chunkX, int chunkZ, DimensionType type) {
        if (predefinedCityMap == null) {
            predefinedCityMap = new HashMap<ChunkCoord, PredefinedCity>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                predefinedCityMap.put(new ChunkCoord(city.getDimension(), city.getChunkX(), city.getChunkZ()), city);
            }
        }
        if (predefinedCityMap.isEmpty()) {
            return null;
        }
        return predefinedCityMap.get(new ChunkCoord(type, chunkX, chunkZ));
    }

    public static PredefinedCity.PredefinedBuilding getPredefinedBuilding(int chunkX, int chunkZ, DimensionType type) {
        if (predefinedBuildingMap == null) {
            predefinedBuildingMap = new HashMap<ChunkCoord, PredefinedCity.PredefinedBuilding>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedCity.PredefinedBuilding building : city.getPredefinedBuildings()) {
                    predefinedBuildingMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + building.getRelChunkX(), city.getChunkZ() + building.getRelChunkZ()), building);
                }
            }
        }
        if (predefinedBuildingMap.isEmpty()) {
            return null;
        }
        return predefinedBuildingMap.get(new ChunkCoord(type, chunkX, chunkZ));
    }

    public static PredefinedCity.PredefinedStreet getPredefinedStreet(int chunkX, int chunkZ, DimensionType type) {
        if (predefinedStreetMap == null) {
            predefinedStreetMap = new HashMap<ChunkCoord, PredefinedCity.PredefinedStreet>();
            for (PredefinedCity city : AssetRegistries.PREDEFINED_CITIES.getIterable()) {
                for (PredefinedCity.PredefinedStreet street : city.getPredefinedStreets()) {
                    predefinedStreetMap.put(new ChunkCoord(city.getDimension(), city.getChunkX() + street.getRelChunkX(), city.getChunkZ() + street.getRelChunkZ()), street);
                }
            }
        }
        if (predefinedStreetMap.isEmpty()) {
            return null;
        }
        return predefinedStreetMap.get(new ChunkCoord(type, chunkX, chunkZ));
    }

    public static boolean isCityCenter(int chunkX, int chunkZ, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider.getType());
        if (city != null) {
            return true;
        }
        Random rand = new Random(provider.getSeed() + (long)chunkZ * 797003437L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        if (provider.getProfile().isSpace()) {
            CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
            if (!sphere.isEnabled()) {
                return rand.nextFloat() < provider.getOutsideProfile().CITY_CHANCE;
            }
            if (sphere.getCenter().getChunkX() == chunkX && sphere.getCenter().getChunkZ() == chunkZ) {
                return rand.nextFloat() < provider.getProfile().CITY_CHANCE;
            }
            return false;
        }
        return rand.nextFloat() < provider.getProfile().CITY_CHANCE;
    }

    public static float getCityRadius(int chunkX, int chunkZ, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider.getType());
        if (city != null) {
            return city.getRadius();
        }
        Random rand = new Random(provider.getSeed() + (long)chunkZ * 100001653L + (long)chunkX * 295075153L);
        rand.nextFloat();
        rand.nextFloat();
        LostCityProfile profile = provider.getProfile();
        int cityRange = profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS;
        if (cityRange < 1) {
            cityRange = 1;
        }
        if (profile.isSpace() && profile.CITYSPHERE_LANDSCAPE_OUTSIDE) {
            if (CitySphere.intersectsWithCitySphere(chunkX, chunkZ, provider)) {
                return profile.CITY_MINRADIUS + rand.nextInt(cityRange);
            }
            return provider.getOutsideProfile().CITY_MINRADIUS + rand.nextInt(provider.getOutsideProfile().CITY_MAXRADIUS - provider.getOutsideProfile().CITY_MINRADIUS);
        }
        return profile.CITY_MINRADIUS + rand.nextInt(cityRange);
    }

    public static String getCityStyleForCityCenter(int chunkX, int chunkZ, IDimensionInfo provider) {
        PredefinedCity city = City.getPredefinedCity(chunkX, chunkZ, provider.getType());
        if (city != null && city.getCityStyle() != null) {
            return city.getCityStyle();
        }
        Random rand = new Random(provider.getSeed() + (long)chunkZ * 899809363L + (long)chunkX * 256203221L);
        rand.nextFloat();
        rand.nextFloat();
        return provider.getWorldStyle().getRandomCityStyle(provider, chunkX, chunkZ, rand);
    }

    public static CityStyle getCityStyle(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        Random rand = new Random(provider.getSeed() + (long)chunkZ * 593441843L + (long)chunkX * 217645177L);
        rand.nextFloat();
        rand.nextFloat();
        int offset = (profile.CITY_MAXRADIUS + 15) / 16;
        ArrayList<Pair<Float, String>> styles = new ArrayList<Pair<Float, String>>();
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                float radius;
                float sqdist;
                if (!City.isCityCenter(cx, cz, provider) || !((sqdist = (float)((cx * 16 - chunkX * 16) * (cx * 16 - chunkX * 16) + (cz * 16 - chunkZ * 16) * (cz * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx, cz, provider)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                float factor = (radius - dist) / radius;
                styles.add((Pair<Float, String>)Pair.of((Object)Float.valueOf(factor), (Object)City.getCityStyleForCityCenter(chunkX, chunkZ, provider)));
            }
        }
        String cityStyleName = styles.isEmpty() ? provider.getWorldStyle().getRandomCityStyle(provider, chunkX, chunkZ, rand) : Tools.getRandomFromList(rand, styles);
        return AssetRegistries.CITYSTYLES.get(cityStyleName);
    }

    public static float getCityFactor(int chunkX, int chunkZ, IDimensionInfo provider, LostCityProfile profile) {
        Float f;
        int cz;
        int cx;
        DimensionType type = provider.getType();
        PredefinedCity.PredefinedBuilding predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ, type);
        if (predefinedBuilding != null) {
            return 1.0f;
        }
        PredefinedCity.PredefinedStreet predefinedStreet = City.getPredefinedStreet(chunkX, chunkZ, type);
        if (predefinedStreet != null) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ, type);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX - 1, chunkZ - 1, type);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        predefinedBuilding = City.getPredefinedBuilding(chunkX, chunkZ - 1, type);
        if (predefinedBuilding != null && predefinedBuilding.isMulti()) {
            return 1.0f;
        }
        for (cx = -4; cx <= 4; ++cx) {
            for (cz = -4; cz <= 4; ++cz) {
            }
        }
        for (cx = -2; cx <= 2; ++cx) {
            for (cz = -2; cz <= 2; ++cz) {
            }
        }
        float factor = 0.0f;
        int offset = (profile.CITY_MAXRADIUS + 15) / 16;
        for (int cx2 = chunkX - offset; cx2 <= chunkX + offset; ++cx2) {
            for (int cz2 = chunkZ - offset; cz2 <= chunkZ + offset; ++cz2) {
                float radius;
                float sqdist;
                LostCityProfile pro = BuildingInfo.getProfile(cx2, cz2, provider);
                if (pro != profile || !City.isCityCenter(cx2, cz2, provider) || !((sqdist = (float)((cx2 * 16 - chunkX * 16) * (cx2 * 16 - chunkX * 16) + (cz2 * 16 - chunkZ * 16) * (cz2 * 16 - chunkZ * 16))) < (radius = City.getCityRadius(cx2, cz2, provider)) * radius)) continue;
                float dist = (float)Math.sqrt(sqdist);
                factor += (radius - dist) / radius;
            }
        }
        float foundFactor = profile.CITY_DEFAULT_BIOME_FACTOR.floatValue();
        Biome biome = BiomeInfo.getBiomeInfo(provider, new ChunkCoord(type, chunkX, chunkZ)).getMainBiome();
        Map<ResourceLocation, Float> map = profile.getBiomeFactorMap();
        ResourceLocation object = biome.getRegistryName();
        try {
            f = map.get(object);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Biome '" + biome.func_210773_k() + "' (" + biome.getRegistryName().func_110623_a() + ") could not be found in the biome registry! This is likely a bug in the mod providing that biome!", e);
        }
        if (f != null) {
            foundFactor = f.floatValue();
        }
        return Math.min(Math.max(factor * foundFactor, 0.0f), 1.0f);
    }

    public static boolean isTooHighForBuilding(Biome[] biomes) {
        return false;
    }
}

