/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.traits.SimpleTrait;

public final class StatModifierTrait
extends SimpleTrait {
    static final ITraitSerializer<StatModifierTrait> SERIALIZER = new SimpleTrait.Serializer<StatModifierTrait>(SilentGear.getId("stat_modifier_trait"), StatModifierTrait::new, StatModifierTrait::readJson, StatModifierTrait::readBuffer, StatModifierTrait::writeBuffer);
    private final Map<ItemStat, StatMod> mods = new HashMap<ItemStat, StatMod>();

    private StatModifierTrait(ResourceLocation name) {
        super(name, SERIALIZER);
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        StatMod mod = this.mods.get(stat);
        if (mod != null) {
            return mod.apply(context.getTraitLevel(), value, damageRatio);
        }
        return value;
    }

    private static void readJson(StatModifierTrait trait, JsonObject json) {
        if (!json.has("stats")) {
            SilentGear.LOGGER.error("JSON file for StatModifierTrait '{}' is missing the 'stats' array", (Object)trait.getId());
            return;
        }
        for (JsonElement element : json.get("stats").getAsJsonArray()) {
            JsonObject obj;
            String statName;
            ItemStat stat;
            if (!element.isJsonObject() || (stat = ItemStat.ALL_STATS.get(statName = JSONUtils.func_151219_a((JsonObject)(obj = element.getAsJsonObject()), (String)"name", (String)""))) == null) continue;
            trait.mods.put(stat, StatMod.fromJson(obj));
        }
    }

    private static void readBuffer(StatModifierTrait trait, PacketBuffer buffer) {
        trait.mods.clear();
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            ItemStat stat = ItemStat.ALL_STATS.get(buffer.func_218666_n());
            trait.mods.put(stat, StatMod.read(buffer));
        }
    }

    private static void writeBuffer(StatModifierTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.mods.size());
        trait.mods.forEach((stat, mod) -> {
            buffer.func_180714_a(stat.getName().func_110623_a());
            ((StatMod)mod).write(buffer);
        });
    }

    private static class StatMod {
        private float multi;
        private boolean factorDamage;
        private boolean factorValue;

        private StatMod() {
        }

        private float apply(int level, float value, float damageRatio) {
            float f = this.multi * (float)level;
            if (this.factorDamage) {
                f *= damageRatio;
            }
            if (this.factorValue) {
                f *= value;
            }
            return value + f;
        }

        private static StatMod fromJson(JsonObject json) {
            StatMod mod = new StatMod();
            mod.multi = JSONUtils.func_151221_a((JsonObject)json, (String)"value", (float)0.0f);
            mod.factorDamage = JSONUtils.func_151209_a((JsonObject)json, (String)"factor_damage", (boolean)true);
            mod.factorValue = JSONUtils.func_151209_a((JsonObject)json, (String)"factor_value", (boolean)true);
            return mod;
        }

        private static StatMod read(PacketBuffer buffer) {
            StatMod mod = new StatMod();
            mod.multi = buffer.readFloat();
            mod.factorDamage = buffer.readBoolean();
            mod.factorValue = buffer.readBoolean();
            return mod;
        }

        private void write(PacketBuffer buffer) {
            buffer.writeFloat(this.multi);
            buffer.writeBoolean(this.factorDamage);
            buffer.writeBoolean(this.factorValue);
        }
    }
}

