/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.traits;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;

public class SimpleTrait
implements ITrait {
    public static final Serializer<SimpleTrait> SERIALIZER = new Serializer<SimpleTrait>(Serializer.access$000(), SimpleTrait::new);
    private final ResourceLocation objId;
    private final ITraitSerializer<?> serializer;
    int maxLevel;
    Set<String> cancelsWith = new HashSet<String>();
    ITextComponent displayName;
    ITextComponent description;
    boolean hidden;

    @Deprecated
    public SimpleTrait(ResourceLocation id) {
        this(id, SERIALIZER);
    }

    public SimpleTrait(ResourceLocation id, ITraitSerializer<?> serializer) {
        this.objId = id;
        this.serializer = serializer;
    }

    @Override
    public ResourceLocation getId() {
        return this.objId;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public boolean willCancelWith(ITrait other) {
        return this.cancelsWith.contains(other.getId().toString());
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        ITextComponent text = this.displayName.func_212638_h();
        if (level > 0) {
            text.func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("enchantment.level." + level, new Object[0]));
        }
        return text;
    }

    @Override
    public ITextComponent getDescription(int level) {
        return this.description.func_212638_h();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        return baseValue;
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        return damageTaken;
    }

    @Override
    public void onGearCrafted(TraitActionContext context) {
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        return value;
    }

    @Override
    public void onGetAttributeModifiers(TraitActionContext context, Multimap<String, AttributeModifier> modifiers, EquipmentSlotType slot) {
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
    }

    public static final class Serializer<T extends SimpleTrait>
    implements ITraitSerializer<T> {
        private static final ResourceLocation NAME = SilentGear.getId("simple_trait");
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> factory;
        @Nullable
        private final BiConsumer<T, JsonObject> readJson;
        @Nullable
        private final BiConsumer<T, PacketBuffer> readBuffer;
        @Nullable
        private final BiConsumer<T, PacketBuffer> writeBuffer;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory) {
            this(serializerId, factory, null, null, null);
        }

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory, @Nullable BiConsumer<T, JsonObject> readJson, @Nullable BiConsumer<T, PacketBuffer> readBuffer, @Nullable BiConsumer<T, PacketBuffer> writeBuffer) {
            this.serializerId = serializerId;
            this.factory = factory;
            this.readJson = readJson;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = JSONUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)1);
            trait.displayName = Serializer.deserializeText(json.get("name"));
            trait.description = Serializer.deserializeText(json.get("description"));
            trait.hidden = JSONUtils.func_151209_a((JsonObject)json, (String)"hidden", (boolean)false);
            if (json.has("cancels_with")) {
                JsonArray array = json.getAsJsonArray("cancels_with");
                for (JsonElement elem : array) {
                    trait.cancelsWith.add(elem.getAsString());
                }
            }
            if (this.readJson != null) {
                this.readJson.accept(trait, json);
            }
            return (T)trait;
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = buffer.readByte();
            trait.displayName = buffer.func_179258_d();
            trait.description = buffer.func_179258_d();
            trait.hidden = buffer.readBoolean();
            int cancelsCount = buffer.func_150792_a();
            for (int i = 0; i < cancelsCount; ++i) {
                trait.cancelsWith.add(buffer.func_150789_c(255));
            }
            if (this.readBuffer != null) {
                this.readBuffer.accept(trait, buffer);
            }
            return (T)trait;
        }

        @Override
        public void write(PacketBuffer buffer, T trait) {
            buffer.writeByte(((SimpleTrait)trait).maxLevel);
            buffer.func_179256_a(((SimpleTrait)trait).displayName);
            buffer.func_179256_a(((SimpleTrait)trait).description);
            buffer.writeBoolean(((SimpleTrait)trait).hidden);
            buffer.func_150787_b(((SimpleTrait)trait).cancelsWith.size());
            for (String str : ((SimpleTrait)trait).cancelsWith) {
                buffer.func_180714_a(str);
            }
            if (this.writeBuffer != null) {
                this.writeBuffer.accept(trait, buffer);
            }
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }

        private static ITextComponent deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = JSONUtils.func_151209_a((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslationTextComponent(name, new Object[0]) : new StringTextComponent(name);
            }
            return Objects.requireNonNull(ITextComponent.Serializer.func_197672_a((JsonElement)json));
        }

        private static ITextComponent readTextComponent(JsonObject json, String name) {
            JsonElement element = json.get(name);
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                boolean translate = JSONUtils.func_151209_a((JsonObject)obj, (String)"translate", (boolean)false);
                String value = JSONUtils.func_151200_h((JsonObject)obj, (String)"name");
                return translate ? new TranslationTextComponent(value, new Object[0]) : new StringTextComponent(value);
            }
            if (element != null) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            throw new JsonParseException("Missing required object '" + name + "'");
        }

        static /* synthetic */ ResourceLocation access$000() {
            return NAME;
        }
    }
}

