/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.RepairContext;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class QuickRepairRecipe
extends SpecialRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("quick_repair");
    public static final Serializer SERIALIZER = new Serializer();

    public QuickRepairRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return false;
        }
        int partsCount = 0;
        for (ItemStack stack : list) {
            if (stack.func_77973_b() instanceof ICoreItem) continue;
            PartData part = PartData.from(stack);
            if (part == null || part.getRepairAmount(gear, RepairContext.Type.QUICK) <= 0.0f) {
                return false;
            }
            ++partsCount;
        }
        return partsCount > 0;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        float repairEfficiency;
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class).func_77946_l();
        Collection parts = list.allMatches(s -> PartManager.from(s) != null);
        if (gear.func_190926_b() || parts.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        float repairValue = 0.0f;
        int materialCount = 0;
        for (ItemStack stack : parts) {
            PartData data = PartData.from(stack);
            if (data == null) continue;
            repairValue += data.getRepairAmount(gear, RepairContext.Type.QUICK);
            ++materialCount;
        }
        repairValue += 1.0f;
        if (gear.func_77973_b() instanceof ICoreItem && (repairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY)) > 0.0f) {
            repairValue *= repairEfficiency;
        }
        gear.func_96631_a(-Math.round(repairValue), SilentGear.random, null);
        GearData.incrementRepairCount(gear, materialCount);
        GearData.recalculateStats(gear, null);
        return gear;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<QuickRepairRecipe> {
        public QuickRepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new QuickRepairRecipe(recipeId);
        }

        public QuickRepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new QuickRepairRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, QuickRepairRecipe recipe) {
        }
    }
}

