/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.config;

import net.minecraftforge.common.ForgeConfigSpec;

final class CommonConfig {
    private static final int MAX = Integer.MAX_VALUE;
    final ForgeConfigSpec.BooleanValue spawn_enable;
    final ForgeConfigSpec.IntValue spawn_delay;
    final ForgeConfigSpec.IntValue spawn_cooldown;
    final ForgeConfigSpec.BooleanValue spawn_force_on_death;
    final ForgeConfigSpec.BooleanValue homes_enable;
    final ForgeConfigSpec.IntValue homes_delay;
    final ForgeConfigSpec.IntValue homes_cooldown;
    final ForgeConfigSpec.IntValue homes_limit;
    final ForgeConfigSpec.IntValue homes_limit_op;
    final ForgeConfigSpec.BooleanValue warps_enable;
    final ForgeConfigSpec.IntValue warps_delay;
    final ForgeConfigSpec.IntValue warps_cooldown;
    final ForgeConfigSpec.BooleanValue back_enable;
    final ForgeConfigSpec.IntValue back_delay;
    final ForgeConfigSpec.IntValue back_cooldown;
    final ForgeConfigSpec.BooleanValue back_death_enable;
    final ForgeConfigSpec.IntValue back_death_custom_cooldown;
    final ForgeConfigSpec.BooleanValue tpa_enable;
    final ForgeConfigSpec.IntValue tpa_delay;
    final ForgeConfigSpec.IntValue tpa_cooldown;
    final ForgeConfigSpec.IntValue tpa_timeout;
    final ForgeConfigSpec.BooleanValue rndtp_enable;
    final ForgeConfigSpec.IntValue rndtp_delay;
    final ForgeConfigSpec.IntValue rndtp_cooldown;
    final ForgeConfigSpec.IntValue rndtp_range_min;
    final ForgeConfigSpec.IntValue rndtp_range_max;
    final ForgeConfigSpec.BooleanValue suicide_enable;
    final ForgeConfigSpec.BooleanValue suicide_enable_player;
    final ForgeConfigSpec.IntValue suicide_player_cooldown;
    final ForgeConfigSpec.BooleanValue time_enable;
    final ForgeConfigSpec.BooleanValue weather_enable;
    final ForgeConfigSpec.BooleanValue heal_enable;
    final ForgeConfigSpec.BooleanValue gm_enable;
    final ForgeConfigSpec.BooleanValue fly_enable;
    final ForgeConfigSpec.BooleanValue god_enable;
    final ForgeConfigSpec.BooleanValue top_enable;
    final ForgeConfigSpec.BooleanValue mute_enable;
    final ForgeConfigSpec.BooleanValue kits_enable;
    final ForgeConfigSpec.BooleanValue kits_starting;
    final ForgeConfigSpec.ConfigValue<String> kits_starting_name;
    final ForgeConfigSpec.BooleanValue speed_enable;
    final ForgeConfigSpec.IntValue speed_max_walk;
    final ForgeConfigSpec.IntValue speed_max_fly;
    final ForgeConfigSpec.BooleanValue tpall_enable;
    final ForgeConfigSpec.BooleanValue kickall_enable;
    final ForgeConfigSpec.BooleanValue broadcast_enable;
    final ForgeConfigSpec.BooleanValue up_enable;
    final ForgeConfigSpec.BooleanValue afk_auto;
    final ForgeConfigSpec.IntValue afk_auto_time;
    final ForgeConfigSpec.IntValue afk_auto_kick;
    final ForgeConfigSpec.BooleanValue afk_command;
    final ForgeConfigSpec.IntValue afk_command_cooldown;
    final ForgeConfigSpec.BooleanValue endc_enable;
    final ForgeConfigSpec.BooleanValue trash_enable;
    final ForgeConfigSpec.BooleanValue tempban_enable;
    final ForgeConfigSpec.BooleanValue check_enable;
    final ForgeConfigSpec.BooleanValue head_enable;
    final ForgeConfigSpec.BooleanValue invsee_enable;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Command Config").push("Commands");
        builder.push("spawn");
        this.spawn_enable = builder.comment("Enable commands: /spawn, /setspawn").define("enable", true);
        this.spawn_delay = builder.defineInRange("delay", 3, 0, Integer.MAX_VALUE);
        this.spawn_cooldown = builder.defineInRange("cooldown", 0, 0, Integer.MAX_VALUE);
        this.spawn_force_on_death = builder.define("force_spawn_on_death", false);
        builder.pop();
        builder.push("homes");
        this.homes_enable = builder.comment("Enable commands: /sethome, /delhome, /home").define("enable", true);
        this.homes_delay = builder.defineInRange("delay", 3, 0, Integer.MAX_VALUE);
        this.homes_cooldown = builder.defineInRange("cooldown", 0, 0, Integer.MAX_VALUE);
        this.homes_limit = builder.defineInRange("limit", 3, 1, Integer.MAX_VALUE);
        this.homes_limit_op = builder.defineInRange("limit_op", 5, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("warps");
        this.warps_enable = builder.comment("Enable commands: /setwarp, /delwarp, /warp").define("enable", true);
        this.warps_delay = builder.defineInRange("delay", 3, 0, Integer.MAX_VALUE);
        this.warps_cooldown = builder.defineInRange("cooldown", 0, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("back");
        this.back_enable = builder.comment("Enable command: /back").define("enable", true);
        this.back_death_enable = builder.define("enable_on_death", true);
        this.back_delay = builder.defineInRange("delay", 3, 0, Integer.MAX_VALUE);
        this.back_cooldown = builder.defineInRange("cooldown", 0, 0, Integer.MAX_VALUE);
        this.back_death_custom_cooldown = builder.defineInRange("death_custom_cooldown", 0, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("tpa");
        this.tpa_enable = builder.comment("Enable commands: /tpa, /tpahere, /tpaccept, /tpdeny").define("enable", true);
        this.tpa_delay = builder.defineInRange("delay", 3, 0, Integer.MAX_VALUE);
        this.tpa_cooldown = builder.defineInRange("cooldown", 0, 0, Integer.MAX_VALUE);
        this.tpa_timeout = builder.defineInRange("timeout", 20, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("rndtp");
        this.rndtp_enable = builder.comment("Enable command: /rndtp").define("enable", true);
        this.rndtp_delay = builder.defineInRange("delay", 3, 0, Integer.MAX_VALUE);
        this.rndtp_cooldown = builder.defineInRange("cooldown", 0, 0, Integer.MAX_VALUE);
        this.rndtp_range_min = builder.defineInRange("range_min", 500, 50, 999);
        this.rndtp_range_max = builder.defineInRange("range_max", 2000, 1000, Integer.MAX_VALUE);
        builder.pop();
        builder.push("suicide");
        this.suicide_enable = builder.comment("Enable command: /suicide").define("enable", true);
        this.suicide_enable_player = builder.define("enable_player", true);
        this.suicide_player_cooldown = builder.defineInRange("cooldown_player", 20, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("time");
        this.time_enable = builder.comment("Enable commands: /day, /night").define("enable", true);
        builder.pop();
        builder.push("weather");
        this.weather_enable = builder.comment("Enable commands: /sun, /rain, /thunder").define("enable", true);
        builder.pop();
        builder.push("heal");
        this.heal_enable = builder.comment("Enable command: /heal").define("enable", true);
        builder.pop();
        builder.push("gm");
        this.gm_enable = builder.comment("Enable command: /gm").define("enable", true);
        builder.pop();
        builder.push("fly");
        this.fly_enable = builder.comment("Enable command: /fly").define("enable", true);
        builder.pop();
        builder.push("god");
        this.god_enable = builder.comment("Enable command: /god").define("enable", true);
        builder.pop();
        builder.push("top");
        this.top_enable = builder.comment("Enable command: /top").define("enable", true);
        builder.pop();
        builder.push("mute");
        this.mute_enable = builder.comment("Enable commands: /mute, /unmute").define("enable", true);
        builder.pop();
        builder.push("kits");
        this.kits_enable = builder.comment("Enable command: /kit").define("enable", true);
        this.kits_starting = builder.define("starting_kit", true);
        this.kits_starting_name = builder.define("starting_kit_name", (Object)"tools");
        builder.pop();
        builder.push("speed");
        this.speed_enable = builder.comment("Enable command: /speed").define("enable", true);
        this.speed_max_walk = builder.defineInRange("max_walk_speed", 20, 0, 50);
        this.speed_max_fly = builder.defineInRange("max_fly_speed", 20, 0, 50);
        builder.pop();
        builder.push("tpall");
        this.tpall_enable = builder.comment("Enable command: /tpall").define("enable", true);
        builder.pop();
        builder.push("kickall");
        this.kickall_enable = builder.comment("Enable command: /kickall").define("enable", true);
        builder.pop();
        builder.push("broadcast");
        this.broadcast_enable = builder.comment("Enable command: /broadcast").define("enable", true);
        builder.pop();
        builder.push("up");
        this.up_enable = builder.comment("Enable command: /up").define("enable", true);
        builder.pop();
        builder.push("afk");
        this.afk_auto = builder.define("auto", true);
        this.afk_auto_time = builder.defineInRange("auto_time", 600, 1, Integer.MAX_VALUE);
        this.afk_auto_kick = builder.defineInRange("auto_kick", 0, 0, Integer.MAX_VALUE);
        this.afk_command = builder.define("command", true);
        this.afk_command_cooldown = builder.defineInRange("cooldown", 30, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("endc");
        this.endc_enable = builder.comment("Enable command: /endc").define("enable", true);
        builder.pop();
        builder.push("trash");
        this.trash_enable = builder.comment("Enable command: /trash").define("enable", true);
        builder.pop();
        builder.push("tempban");
        this.tempban_enable = builder.comment("Enable commands: /tempban, /unban").define("enable", true);
        builder.pop();
        builder.push("tempban");
        this.check_enable = builder.comment("Enable command: /check").define("enable", true);
        builder.pop();
        builder.push("head");
        this.head_enable = builder.comment("Enable command: /head").define("enable", true);
        builder.pop();
        builder.push("invsee");
        this.invsee_enable = builder.comment("Enable command: /invsee").define("enable", true);
        builder.pop();
    }
}

