/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public class CommandRndtp {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"rndtp").requires(source -> source.func_197034_c(0))).executes(context -> CommandRndtp.rndtp((CommandSource)context.getSource())));
    }

    private static int rndtp(CommandSource source) throws CommandSyntaxException {
        ServerWorld world = source.func_197023_e();
        ServerPlayerEntity player = source.func_197035_h();
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        long cooldown = eslPlayer.getUsage().getTeleportCooldown("rndtp", ConfigValues.rndtp_cooldown.intValue());
        if (cooldown != 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.cooldown", cooldown));
            return 1;
        }
        Location spawnLocation = DataManager.getWorld().getSpawn();
        if (spawnLocation.getDimensionID() != player.field_71093_bK.func_186068_a()) {
            player.func_145747_a((ITextComponent)Methods.formatText("rndtp.maessentials.dimension", new Object[0]));
            return 1;
        }
        Location location = CommandRndtp.findRandomTp((World)world, spawnLocation, player, 0);
        if (location == null) {
            player.func_145747_a((ITextComponent)Methods.formatText("rndtp.maessentials.not_found", new Object[0]));
            return 1;
        }
        eslPlayer.getUsage().setCommandUsage("rndtp");
        eslPlayer.saveData();
        if (Methods.simpleTeleport(player, location, "rndtp", ConfigValues.rndtp_delay.intValue())) {
            if (ConfigValues.rndtp_delay == 0) {
                player.func_145747_a((ITextComponent)Methods.formatText("rndtp.maessentials.teleport", new Object[0]));
            } else {
                player.func_145747_a((ITextComponent)Methods.formatText("rndtp.maessentials.teleport.wait", ConfigValues.rndtp_delay));
            }
        }
        return 1;
    }

    private static Location findRandomTp(World world, Location spawnLocation, ServerPlayerEntity player, int count) {
        if (count == 10) {
            return null;
        }
        ++count;
        Random rand = new Random();
        int min = ConfigValues.rndtp_range_min;
        int max = ConfigValues.rndtp_range_max;
        int x = (int)Math.round(spawnLocation.x) + rand.nextInt(max + min) - min;
        int y = world.getMaxHeight();
        int z = (int)Math.round(spawnLocation.z) + rand.nextInt(max + min) - min;
        Chunk chunk = world.func_212866_a_(x >> 4, z >> 4);
        Biome biome = world.func_226691_t_(new BlockPos(x, y, z));
        if (biome.func_201856_r().func_222352_a().equals("ocean")) {
            return CommandRndtp.findRandomTp(world, spawnLocation, player, count);
        }
        while (y > 0) {
            BlockPos headPos;
            BlockPos legPos;
            BlockPos groundPos;
            if (chunk.func_180495_p(groundPos = new BlockPos(x, --y - 2, z)).func_185904_a().equals(Material.field_151579_a) || chunk.func_180495_p(groundPos).func_177230_c().equals(Blocks.field_150357_h) || y - 2 == 1 || !chunk.func_180495_p(legPos = new BlockPos(x, y - 1, z)).func_185904_a().equals(Material.field_151579_a) || !chunk.func_180495_p(headPos = new BlockPos(x, y, z)).func_185904_a().equals(Material.field_151579_a)) continue;
            return new Location((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f, spawnLocation.getDimensionID());
        }
        return CommandRndtp.findRandomTp(world, spawnLocation, player, count);
    }
}

