/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItem;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.fluid.FluidHandlerHeroMedallion;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.XpHelper;

public class HeroMedallionItem
extends ToggleableItem
implements IPedestalActionItem {
    public HeroMedallionItem() {
        super("hero_medallion", new Item.Properties().func_200918_c(0).setNoRepair());
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack medallion, @Nullable World world, List<ITextComponent> tooltip) {
        int experience = NBTHelper.getInt("experience", medallion);
        int levels = XpHelper.getLevelForExperience(experience);
        int remainingExperience = experience - XpHelper.getExperienceForLevel(levels);
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"levels", (Object)String.valueOf(levels), (Object)"experience", (Object)String.valueOf(remainingExperience)), tooltip);
        if (this.isEnabled(medallion)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GREEN + "XP")), tooltip);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    private int getExperienceMinimum() {
        return (Integer)Settings.COMMON.items.heroMedallion.experienceLevelMinimum.get();
    }

    private int getExperienceMaximum() {
        return (Integer)Settings.COMMON.items.heroMedallion.experienceLevelMaximum.get();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!this.isEnabled(stack)) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            int levelLoop = 0;
            while (true) {
                double d = levelLoop;
                double d2 = !player.func_184812_l_() ? (double)player.field_71068_ca : 30.0;
                if (!(d <= Math.sqrt(d2))) break;
                if ((player.field_71068_ca > this.getExperienceMinimum() || player.field_71106_cc >= 1.0f / (float)player.func_71050_bK() || player.func_184812_l_()) && this.getExperience(stack) < (Integer)Settings.COMMON.items.heroMedallion.experienceLimit.get()) {
                    if (!player.func_184812_l_()) {
                        this.decreasePlayerExperience(player);
                    }
                    this.increaseMedallionExperience(stack);
                }
                ++levelLoop;
            }
        }
    }

    private void decreasePlayerExperience(PlayerEntity player) {
        player.field_71106_cc -= 1.0f / (float)player.func_71050_bK();
        player.field_71067_cb -= Math.min(1, player.field_71067_cb);
        if (player.field_71106_cc < 0.0f) {
            this.decreasePlayerLevel(player);
        }
    }

    private void decreaseMedallionExperience(ItemStack stack) {
        this.decreaseMedallionExperience(stack, 1);
    }

    private void decreaseMedallionExperience(ItemStack stack, int experience) {
        this.setExperience(stack, this.getExperience(stack) - experience);
    }

    private void decreasePlayerLevel(PlayerEntity player) {
        float experienceToRemove = -player.field_71106_cc * (float)player.func_71050_bK();
        --player.field_71068_ca;
        player.field_71106_cc = 1.0f - experienceToRemove / (float)player.func_71050_bK();
    }

    private void increasePlayerExperience(PlayerEntity player) {
        player.func_195068_e(1);
    }

    private void increaseMedallionExperience(ItemStack stack) {
        this.setExperience(stack, this.getExperience(stack) + 1);
    }

    public int getExperience(ItemStack stack) {
        return NBTHelper.getInt("experience", stack);
    }

    public void setExperience(ItemStack stack, int i) {
        NBTHelper.putInt("experience", stack, i);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (player.func_225608_bj_()) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult rayTraceResult = HeroMedallionItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            int playerLevel = player.field_71068_ca;
            while (player.field_71068_ca < this.getExperienceMaximum() && playerLevel == player.field_71068_ca && (this.getExperience(stack) > 0 || player.func_184812_l_())) {
                this.increasePlayerExperience(player);
                if (player.func_184812_l_()) continue;
                this.decreaseMedallionExperience(stack);
            }
        } else {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)rayTraceResult;
            BlockPos hitPos = blockResult.func_216350_a().func_177971_a(blockResult.func_216354_b().func_176730_m());
            this.spawnXpOnGround(stack, world, hitPos);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    private void spawnXpOnGround(ItemStack stack, World world, BlockPos hitPos) {
        int xp;
        if (this.getExperience(stack) >= xp) {
            int j;
            this.decreaseMedallionExperience(stack, xp);
            for (xp = Math.min((Integer)Settings.COMMON.items.heroMedallion.experienceDrop.get(), this.getExperience(stack)); xp > 0; xp -= j) {
                j = ExperienceOrbEntity.func_70527_a((int)xp);
                world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p(), j));
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerHeroMedallion(stack);
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        List<BlockPos> posInRange = pedestal.getPedestalsInRange((Integer)Settings.COMMON.items.heroMedallion.pedestalRange.get());
        World world = pedestal.getTheWorld();
        for (BlockPos pedestalPos : posInRange) {
            InventoryHelper.getInventoryAtPos(world, pedestalPos).ifPresent(pedestalInventory -> {
                List<ItemStack> toRepair = this.getMendingItemsForRepair((IItemHandler)pedestalInventory);
                for (ItemStack itemToRepair : toRepair) {
                    int xpToRepair = Math.min((Integer)Settings.COMMON.items.heroMedallion.pedestalRepairStepXP.get(), this.getExperience(stack));
                    int durabilityToRepair = Math.min(XpHelper.xpToDurability(xpToRepair), itemToRepair.func_77952_i());
                    this.setExperience(stack, this.getExperience(stack) - XpHelper.durabilityToXp(durabilityToRepair));
                    itemToRepair.func_196085_b(itemToRepair.func_77952_i() - durabilityToRepair);
                }
            });
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.items.heroMedallion.pedestalCoolDown.get());
    }

    private List<ItemStack> getMendingItemsForRepair(IItemHandler inventory) {
        NonNullList stacksToReturn = NonNullList.func_191196_a();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!stack.func_77951_h() || stack.func_77952_i() <= 1 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0) continue;
            stacksToReturn.add((Object)stack);
        }
        return stacksToReturn;
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }
}

