/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.common.gui.ContainerAlkahestTome;
import xreliquary.crafting.AlkahestryChargingRecipe;
import xreliquary.crafting.AlkahestryRecipeRegistry;
import xreliquary.init.ModSounds;
import xreliquary.items.ToggleableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;

public class AlkahestryTomeItem
extends ToggleableItem {
    public AlkahestryTomeItem() {
        super("alkahestry_tome", new Item.Properties().setNoRepair().func_208103_a(Rarity.EPIC));
    }

    public int getMaxDamage(ItemStack stack) {
        return AlkahestryTomeItem.getChargeLimit() + 1;
    }

    public int getDamage(ItemStack stack) {
        return this.getMaxDamage(stack) - AlkahestryTomeItem.getCharge(stack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y != EnchantmentType.BREAKABLE && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack newStack = (ItemStack)super.func_77659_a(world, player, hand).func_188398_b();
        if (player.func_225608_bj_()) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)newStack);
        }
        player.func_184185_a(ModSounds.book, 1.0f, 1.0f);
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new ContainerAlkahestTome(w), stack.func_200301_q()));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack tome, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !this.isEnabled(tome)) {
            return;
        }
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        for (AlkahestryChargingRecipe recipe : AlkahestryRecipeRegistry.getChargingRecipes()) {
            if (AlkahestryTomeItem.getCharge(tome) + recipe.getChargeToAdd() > AlkahestryTomeItem.getChargeLimit() || !this.consumeItem(recipe, player)) continue;
            AlkahestryTomeItem.addCharge(tome, recipe.getChargeToAdd());
        }
    }

    private boolean consumeItem(AlkahestryChargingRecipe recipe, PlayerEntity player) {
        return InventoryHelper.consumeItem(is -> recipe.getChargingIngredient().test(is), player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack tome, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"chargeAmount", (Object)String.valueOf(AlkahestryTomeItem.getCharge(tome)), (Object)"chargeLimit", (Object)String.valueOf(AlkahestryTomeItem.getChargeLimit())), tooltip);
        if (this.isEnabled(tome)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.RED + AlkahestryRecipeRegistry.getDrainRecipe().func_77571_b().func_200301_q().getString())), tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        items.add((Object)stack);
    }

    public static int getChargeLimit() {
        return (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get();
    }

    public static ItemStack setCharge(ItemStack tome, int charge) {
        NBTHelper.putInt("charge", tome, charge);
        return tome;
    }

    public static int getCharge(ItemStack tome) {
        return NBTHelper.getInt("charge", tome);
    }

    public static void addCharge(ItemStack tome, int chageToAdd) {
        AlkahestryTomeItem.setCharge(tome, AlkahestryTomeItem.getCharge(tome) + chageToAdd);
    }

    public void useCharge(ItemStack tome, int chargeToUse) {
        AlkahestryTomeItem.addCharge(tome, -chargeToUse);
    }
}

