/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xreliquary.entities.ConcussiveExplosion;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class BusterShotEntity
extends ShotEntityBase {
    public BusterShotEntity(EntityType<BusterShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public BusterShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.BUSTER_SHOT, world, player, hand);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        ConcussiveExplosion.customBusterExplosion(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 4.0f);
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.func_226277_ct_() + this.smallGauss(0.1), this.func_226278_cu_() + this.smallGauss(0.1), this.func_226281_cx_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197601_L);
        }
    }

    @Override
    void spawnHitParticles(int i) {
    }

    @Override
    protected void onImpact(LivingEntity entityLiving) {
        ConcussiveExplosion.customBusterExplosion(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 4.0f);
        super.onImpact(entityLiving);
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.BUSTER;
    }
}

