/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.alkahestry;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xreliquary.compat.jei.alkahestry.AlkahestryRecipeCategory;
import xreliquary.crafting.AlkahestryCraftingRecipe;
import xreliquary.init.ModItems;
import xreliquary.items.AlkahestryTomeItem;
import xreliquary.reference.Reference;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;

public class AlkahestryCraftingRecipeCategory
extends AlkahestryRecipeCategory<AlkahestryCraftingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("xreliquary", "alkahestry_crafting");
    private static final int INPUT_SLOT = 0;
    private static final int TOME_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private static final int TOME_OUTPUT_SLOT = 3;
    private final IDrawable background;
    private final String localizedName;

    public AlkahestryCraftingRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, UID);
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/alkahest_crafting.png"), 0, 0, 95, 76);
        this.localizedName = LanguageHelper.getLocalization("jei.xreliquary.recipe.alkahest_crafting", new Object[0]);
    }

    public Class<? extends AlkahestryCraftingRecipe> getRecipeClass() {
        return AlkahestryCraftingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setIngredients(AlkahestryCraftingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        NonNullList outputs = NonNullList.func_191196_a();
        outputs.add((Object)recipe.func_77571_b());
        outputs.add((Object)AlkahestryTomeItem.setCharge(new ItemStack((IItemProvider)ModItems.ALKAHESTRY_TOME), (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get() - recipe.getChargeNeeded()));
        ingredients.setOutputs(VanillaTypes.ITEM, (List)outputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlkahestryCraftingRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 0, 0);
        recipeLayout.getItemStacks().init(1, true, 18, 0);
        recipeLayout.getItemStacks().init(2, false, 73, 9);
        recipeLayout.getItemStacks().init(3, false, 18, 59);
        List ingredientsInputs = ingredients.getInputs(VanillaTypes.ITEM);
        ItemStack input = (ItemStack)((List)ingredientsInputs.get(0)).get(0);
        ItemStack tome = (ItemStack)((List)ingredientsInputs.get(1)).get(0);
        ItemStack output = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)).get(0);
        ItemStack tomeOutput = (ItemStack)((List)ingredients.getOutputs(VanillaTypes.ITEM).get(1)).get(0);
        recipeLayout.getItemStacks().set(0, input);
        recipeLayout.getItemStacks().set(1, tome);
        recipeLayout.getItemStacks().set(2, output);
        recipeLayout.getItemStacks().set(3, tomeOutput);
    }

    public void draw(AlkahestryCraftingRecipe recipe, double mouseX, double mouseY) {
        String chargeString = "-" + recipe.getChargeNeeded();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(chargeString);
        fontRenderer.func_211126_b(chargeString, (float)(((double)this.background.getWidth() - (double)stringWidth) / 2.0), 40.0f, -8355712);
    }
}

