/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import xreliquary.reference.Settings;

public class FertileLilyPadBlock
extends BushBlock {
    private static final VoxelShape AABB = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Water;
    }

    public FertileLilyPadBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c());
        this.setRegistryName("xreliquary", "fertile_lily_pad");
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.growCropsNearby(world, pos, state);
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + 0.5 + rand.nextGaussian() / 8.0, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5 + rand.nextGaussian() / 8.0, 0.0, 0.9, 0.5);
    }

    private int secondsBetweenGrowthTicks() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.secondsBetweenGrowthTicks.get();
    }

    private int tileRange() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.tileRange.get();
    }

    private int fullPotencyRange() {
        return (Integer)Settings.COMMON.blocks.fertileLilypad.fullPotencyRange.get();
    }

    private void growCropsNearby(ServerWorld world, BlockPos pos, BlockState state) {
        int xO = pos.func_177958_n();
        int yO = pos.func_177956_o();
        int zO = pos.func_177952_p();
        for (int xD = -this.tileRange(); xD <= this.tileRange(); ++xD) {
            for (int yD = -1; yD <= this.tileRange(); ++yD) {
                for (int zD = -this.tileRange(); zD <= this.tileRange(); ++zD) {
                    int x = xO + xD;
                    int y = yO + yD;
                    int z = zO + zD;
                    BlockState cropState = world.func_180495_p(new BlockPos(x, y, z));
                    Block cropBlock = cropState.func_177230_c();
                    if (!(cropBlock instanceof IPlantable) && !(cropBlock instanceof IGrowable) || cropBlock instanceof FertileLilyPadBlock) continue;
                    double distance = Math.sqrt(Math.pow((double)x - (double)xO, 2.0) + Math.pow((double)y - (double)yO, 2.0) + Math.pow((double)z - (double)zO, 2.0));
                    this.tickCropBlock(world, x, y, z, cropState, cropBlock, distance);
                }
            }
        }
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), this.secondsBetweenGrowthTicks() * 20);
    }

    private void tickCropBlock(ServerWorld world, int x, int y, int z, BlockState cropState, Block cropBlock, double distance) {
        distance -= (double)this.fullPotencyRange();
        distance = Math.max(1.0, distance);
        double distanceCoefficient = 1.0 - distance / (double)this.tileRange();
        BlockPos pos = new BlockPos(x, y, z);
        world.func_205220_G_().func_205360_a(pos, (Object)cropBlock, (int)(distanceCoefficient * (double)this.secondsBetweenGrowthTicks() * 20.0));
        cropBlock.func_225534_a_(cropState, world, pos, world.field_73012_v);
        world.func_217379_c(2005, pos, Math.max((int)((double)this.tileRange() - distance), 1));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (entityIn instanceof BoatEntity) {
            worldIn.func_175655_b(new BlockPos((Vec3i)pos), true);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        IFluidState ifluidstate = worldIn.func_204610_c(pos);
        return ifluidstate.func_206886_c() == Fluids.field_204546_a || state.func_185904_a() == Material.field_151588_w;
    }
}

