/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerEnergy;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFluxCompressor
extends TileEntityPneumaticBase
implements IRedstoneControlled,
INamedContainerProvider {
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);

    public TileEntityFluxCompressor() {
        super((TileEntityType)ModTileEntities.FLUX_COMPRESSOR.get(), 20.0f, 25.0f, 10000, 4);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() * (float)PNCConfig.Common.Machines.fluxCompressorEfficiency / 100.0f / 100.0f);
                this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades());
            }
            if (this.redstoneAllows() && this.energy.getEnergyStored() >= this.rfPerTick) {
                this.addAir(this.airPerTick);
                this.energy.extractEnergy(this.rfPerTick, false);
                this.heatExchanger.addHeat((double)this.rfPerTick / 100.0);
            }
            this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation().func_176734_d() : null);
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation().func_176734_d();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side != this.getRotation().func_176734_d()) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone") && ++this.redstoneMode == 2) {
            this.redstoneMode = 0;
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    public int getInfoEnergyPerTick() {
        return this.rfPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getAirRate() {
        return this.airPerTick;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerEnergy((ContainerType)ModContainers.FLUX_COMPRESSOR.get(), i, playerInventory, this.func_174877_v());
    }
}

