/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

class EntityFilterPair<T extends IProgWidget & IEntityProvider> {
    private final T widget;
    private final EntityFilter entityWhitelist;
    private final EntityFilter entityBlacklist;
    private String errorWhite = "";
    private String errorBlack = "";

    EntityFilterPair(T widget) {
        this.widget = widget;
        this.entityWhitelist = this.getFilter(widget, true);
        this.entityBlacklist = this.getFilter(widget, false);
    }

    public static <T extends IProgWidget & IEntityProvider> void addErrors(T widget, List<ITextComponent> errors) {
        EntityFilterPair<T> filter = new EntityFilterPair<T>(widget);
        if (!filter.errorWhite.isEmpty()) {
            errors.add((ITextComponent)new StringTextComponent("Invalid whitelist filter: " + filter.errorWhite));
        }
        if (!filter.errorBlack.isEmpty()) {
            errors.add((ITextComponent)new StringTextComponent("Invalid blacklist filter: " + filter.errorBlack));
        }
    }

    private EntityFilter getFilter(T widget, boolean whitelist) {
        try {
            return EntityFilter.fromProgWidget(widget, whitelist);
        }
        catch (IllegalArgumentException e) {
            if (whitelist) {
                this.errorWhite = e.getMessage();
                return EntityFilter.allow();
            }
            this.errorBlack = e.getMessage();
            return EntityFilter.deny();
        }
    }

    boolean isEntityValid(Entity e) {
        return this.entityWhitelist.test(e) && !this.entityBlacklist.test(e);
    }

    List<Entity> getValidEntities(World world) {
        return this.getEntitiesInArea((ProgWidgetArea)this.widget.getConnectedParameters()[0], (ProgWidgetArea)this.widget.getConnectedParameters()[this.widget.getParameters().size()], world);
    }

    private List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, World world) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, this.entityWhitelist));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            entities.removeAll(widget.getEntitiesWithinArea(world, this.entityWhitelist));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (this.entityBlacklist != null) {
            entities.removeIf(this.entityBlacklist);
        }
        return new ArrayList<Entity>(entities);
    }
}

