/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Map;
import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ItemDrone
extends ItemPressurizable
implements IChargeableContainerProvider,
IProgrammable,
IUpgradeAcceptor {
    private final BiFunction<World, PlayerEntity, EntityDrone> droneCreator;
    private final boolean programmable;

    public ItemDrone(BiFunction<World, PlayerEntity, EntityDrone> droneCreator, boolean programmable) {
        super(120000, 12000);
        this.droneCreator = droneCreator;
        this.programmable = programmable;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (!world.field_72995_K) {
            ItemStack iStack = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
            if (iStack.func_77973_b() == ModItems.LOGISTICS_DRONE.get()) {
                AdvancementTriggers.LOGISTICS_DRONE_DEPLOYED.trigger((ServerPlayerEntity)ctx.func_195999_j());
            }
            BlockPos placePos = pos.func_177972_a(ctx.func_196000_l());
            this.spawnDrone(ctx.func_195999_j(), world, pos, ctx.func_196000_l(), placePos, iStack);
            iStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public void spawnDrone(PlayerEntity player, World world, BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack iStack) {
        EntityDrone drone = this.droneCreator.apply(world, player);
        drone.func_70107_b((double)placePos.func_177958_n() + 0.5, (double)placePos.func_177956_o() + 0.5, (double)placePos.func_177952_p() + 0.5);
        drone.readFromItemStack(iStack);
        world.func_217376_c((Entity)drone);
        if (drone.addProgram(clickPos, facing, placePos, iStack, drone.progWidgets)) {
            TileEntityProgrammer.updatePuzzleConnections(drone.progWidgets);
        }
        drone.func_213386_a((IWorld)world, world.func_175649_E(placePos), SpawnReason.TRIGGERED, new ILivingEntityData(){}, null);
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.programmable;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_77658_a();
    }

    @Override
    public INamedContainerProvider getContainerProvider(TileEntityChargingStation te) {
        return new IChargeableContainerProvider.Provider(te, (ContainerType)ModContainers.CHARGING_DRONE.get());
    }
}

