/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import me.desht.pneumaticcraft.client.TubeModuleClientRegistry;
import me.desht.pneumaticcraft.client.model.module.AbstractModelRenderer;
import me.desht.pneumaticcraft.common.block.BlockPressureTube;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class RenderPressureTubeModule
extends TileEntityRenderer<TileEntityPressureTube> {
    private final Map<ResourceLocation, AbstractModelRenderer> models = new HashMap<ResourceLocation, AbstractModelRenderer>();

    public RenderPressureTubeModule(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(TileEntityPressureTube tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        int i;
        if (tile.getCamouflage() != null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Hand holdingModule = null;
        if (mc.field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemTubeModule) {
            holdingModule = Hand.MAIN_HAND;
        } else if (mc.field_71439_g.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof ItemTubeModule) {
            holdingModule = Hand.OFF_HAND;
        }
        boolean render = false;
        for (i = 0; i < tile.modules.length; ++i) {
            if (tile.modules[i] == null) continue;
            render = true;
        }
        if (!render && holdingModule == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        if (holdingModule != null) {
            this.attachFakeModule(mc, tile, holdingModule);
        }
        for (i = 0; i < tile.modules.length; ++i) {
            TubeModule module = tile.modules[i];
            if (module == null) continue;
            this.getModel(module).renderModule(module, matrixStack, buffer, partialTicks, combinedLight, combinedOverlay);
            if (!module.isFake()) continue;
            tile.modules[i] = null;
        }
        matrixStack.func_227865_b_();
    }

    private AbstractModelRenderer getModel(TubeModule module) {
        return this.models.computeIfAbsent(module.getType(), k -> TubeModuleClientRegistry.createModel(module));
    }

    private void attachFakeModule(Minecraft mc, TileEntityPressureTube tile, Hand hand) {
        BlockRayTraceResult brtr;
        if (mc.field_71476_x instanceof BlockRayTraceResult && (brtr = (BlockRayTraceResult)mc.field_71476_x).func_216350_a().equals((Object)tile.func_174877_v()) && mc.field_71441_e.func_175625_s(brtr.func_216350_a()) == tile) {
            ((BlockPressureTube)ModBlocks.PRESSURE_TUBE.get()).tryPlaceModule((PlayerEntity)mc.field_71439_g, (World)mc.field_71441_e, tile.func_174877_v(), brtr.func_216354_b(), hand, true);
        }
    }
}

