/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractTileModelRenderer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderElevatorBase
extends AbstractTileModelRenderer<TileEntityElevatorBase> {
    private static final float FACTOR = 0.5625f;
    private final ModelRenderer pole1 = new ModelRenderer(64, 64, 0, 17);
    private final ModelRenderer pole2;
    private final ModelRenderer pole3;
    private final ModelRenderer pole4;
    private final ModelRenderer floor;

    public RenderElevatorBase(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.pole1.func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 14.0f, 2.0f);
        this.pole1.func_78793_a(-1.0f, 9.0f, -1.0f);
        this.pole1.field_78809_i = true;
        this.pole2 = new ModelRenderer(64, 64, 0, 17);
        this.pole2.func_228300_a_(0.0f, 0.0f, 0.0f, 4.0f, 14.0f, 4.0f);
        this.pole2.func_78793_a(-2.0f, 9.0f, -2.0f);
        this.pole2.field_78809_i = true;
        this.pole3 = new ModelRenderer(64, 64, 0, 17);
        this.pole3.func_228300_a_(0.0f, 0.0f, 0.0f, 6.0f, 14.0f, 6.0f);
        this.pole3.func_78793_a(-3.0f, 9.0f, -3.0f);
        this.pole3.field_78809_i = true;
        this.pole4 = new ModelRenderer(64, 64, 0, 17);
        this.pole4.func_228300_a_(0.0f, 0.0f, 0.0f, 8.0f, 14.0f, 8.0f);
        this.pole4.func_78793_a(-4.0f, 9.0f, -4.0f);
        this.pole4.field_78809_i = true;
        this.floor = new ModelRenderer(64, 64, 0, 0);
        this.floor.func_228300_a_(0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f);
        this.floor.func_78793_a(-8.0f, 8.0f, -8.0f);
        this.floor.field_78809_i = true;
    }

    @Override
    public void renderModel(TileEntityElevatorBase te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.extension == 0.0f) {
            return;
        }
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228638_b_((ResourceLocation)Textures.MODEL_ELEVATOR));
        float extension = MathHelper.func_219799_g((float)partialTicks, (float)te.oldExtension, (float)te.extension);
        this.renderPole(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, this.pole4, 0, extension);
        this.renderPole(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, this.pole3, 1, extension);
        this.renderPole(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, this.pole2, 2, extension);
        this.renderPole(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, this.pole1, 3, extension);
        this.floor.func_228308_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected void renderExtras(TileEntityElevatorBase te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.fakeFloorTextureUV != null && te.fakeFloorTextureUV.length == 4) {
            matrixStack.func_227860_a_();
            float extension = te.oldExtension + (te.extension - te.oldExtension) * partialTicks;
            matrixStack.func_227861_a_(0.0, (double)(extension + 1.0005f), 0.0);
            IVertexBuilder builder = iRenderTypeBuffer.getBuffer(ModRenderTypes.getTextureRender(AtlasTexture.field_110575_b));
            float uMin = te.fakeFloorTextureUV[0];
            float vMin = te.fakeFloorTextureUV[1];
            float uMax = te.fakeFloorTextureUV[2];
            float vMax = te.fakeFloorTextureUV[3];
            Matrix4f posMat = matrixStack.func_227866_c_().func_227870_a_();
            builder.func_227888_a_(posMat, 0.0f, 0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMax).func_227886_a_(combinedLightIn).func_181675_d();
            builder.func_227888_a_(posMat, 1.0f, 0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMax).func_227886_a_(combinedLightIn).func_181675_d();
            builder.func_227888_a_(posMat, 1.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMax, vMin).func_227886_a_(combinedLightIn).func_181675_d();
            builder.func_227888_a_(posMat, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uMin, vMin).func_227886_a_(combinedLightIn).func_181675_d();
            matrixStack.func_227865_b_();
        }
    }

    private void renderPole(MatrixStack matrixStackIn, IVertexBuilder builder, int combinedLightIn, int combinedOverlayIn, ModelRenderer pole, int idx, float extension) {
        matrixStackIn.func_227861_a_(0.0, (double)(-extension / 4.0f), 0.0);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.5625, 0.0);
        matrixStackIn.func_227862_a_(1.0f, extension * 16.0f / 14.0f / 4.0f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, -0.5625, 0.0);
        pole.func_228309_a_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, 1.0f - (float)idx * 0.15f, 1.0f - (float)idx * 0.15f, 1.0f - (float)idx * 0.15f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public boolean isGlobalRenderer(TileEntityElevatorBase te) {
        return true;
    }
}

