/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderEntityTarget;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.HackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class EntityTrackHandler {
    private static final List<Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>> trackEntries = new ArrayList<Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>>();

    public static void registerDefaultEntries() {
        IPneumaticHelmetRegistry manager = PneumaticRegistry.getInstance().getHelmetRegistry();
        manager.registerEntityTrackEntry(EntityTrackEntryLivingBase::new);
        manager.registerEntityTrackEntry(EntityTrackEntryHackable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryDrone::new);
        manager.registerEntityTrackEntry(EntityTrackEntryPressurizable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryAgeable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryTameable::new);
        manager.registerEntityTrackEntry(EntityTrackEntryCreeper::new);
        manager.registerEntityTrackEntry(EntityTrackEntrySlime::new);
        manager.registerEntityTrackEntry(EntityTrackEntryPlayer::new);
        manager.registerEntityTrackEntry(EntityTrackEntryMob::new);
        manager.registerEntityTrackEntry(EntityTrackEntryItemFrame::new);
        manager.registerEntityTrackEntry(EntityTrackEntryPainting::new);
    }

    public static void init() {
        for (Supplier<? extends IEntityTrackEntry> sup : PneumaticHelmetRegistry.getInstance().entityTrackEntries) {
            trackEntries.add((Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry>)Pair.of(sup, (Object)sup.get()));
        }
    }

    public static List<IEntityTrackEntry> getTrackersForEntity(Entity entity) {
        ArrayList<IEntityTrackEntry> trackers = new ArrayList<IEntityTrackEntry>();
        for (Pair<Supplier<? extends IEntityTrackEntry>, IEntityTrackEntry> pair : trackEntries) {
            if (!((IEntityTrackEntry)pair.getRight()).isApplicable(entity)) continue;
            IEntityTrackEntry newTracker = (IEntityTrackEntry)((Supplier)pair.getLeft()).get();
            newTracker.isApplicable(entity);
            trackers.add(newTracker);
        }
        return trackers;
    }

    private static ItemStack[] asItemStackArray(NonNullList<ItemStack> stacks) {
        return (ItemStack[])stacks.stream().filter(stack -> !stack.func_190926_b()).toArray(ItemStack[]::new);
    }

    public static class EntityTrackEntryItemFrame
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof ItemFrameEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            ItemFrameEntity frame = (ItemFrameEntity)entity;
            ItemStack stack = frame.func_82335_i();
            if (!stack.func_190926_b()) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.itemframe.item", (Object[])new Object[]{stack.func_200301_q().func_150254_d()}));
                if (frame.func_82333_j() != 0) {
                    curInfo.add(I18n.func_135052_a((String)"entityTracker.info.itemframe.rotation", (Object[])new Object[]{frame.func_82333_j() * 45}));
                }
            }
        }
    }

    public static class EntityTrackEntryPainting
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof PaintingEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            PaintingType art = ((PaintingEntity)entity).field_70522_e;
            if (art != null) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.painting.art", (Object[])new Object[]{art.getRegistryName().func_110623_a()}));
            }
        }
    }

    public static class EntityTrackEntryHackable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return HackUpgradeHandler.enabledForPlayer(ClientUtils.getClientPlayer());
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            PlayerEntity player = ClientUtils.getClientPlayer();
            IHackableEntity hackable = HackableHandler.getHackableForEntity(entity, player);
            if (hackable != null) {
                int hackTime = HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargetsStream().filter(target -> target.entity == entity).findFirst().map(RenderEntityTarget::getHackTime).orElse(0);
                if (hackTime == 0) {
                    if (isLookingAtTarget) {
                        hackable.addHackInfo(entity, curInfo, player);
                        HackUpgradeHandler.addKeybindTooltip(curInfo);
                    }
                } else {
                    int requiredHackTime = hackable.getHackTime(entity, player);
                    int percentageComplete = hackTime * 100 / requiredHackTime;
                    if (percentageComplete < 100) {
                        curInfo.add(I18n.func_135052_a((String)"pneumaticHelmet.hacking.hacking", (Object[])new Object[]{percentageComplete}));
                    } else if (hackTime < requiredHackTime + 20) {
                        hackable.addPostHackInfo(entity, curInfo, player);
                    } else if (isLookingAtTarget) {
                        hackable.addHackInfo(entity, curInfo, player);
                        HackUpgradeHandler.addKeybindTooltip(curInfo);
                    }
                }
            }
        }
    }

    public static class EntityTrackEntryPlayer
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof PlayerEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            PlayerEntity player = (PlayerEntity)entity;
            EntityTrackEntryPlayer.addInventory("entityTracker.info.player.armor", curInfo, (NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
            EntityTrackEntryPlayer.addInventory("entityTracker.info.player.holding", curInfo, (NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        }

        private static void addInventory(String title, List<String> curInfo, NonNullList<ItemStack> stacks) {
            curInfo.add(TextFormatting.GRAY + I18n.func_135052_a((String)title, (Object[])new Object[0]));
            ArrayList<ITextComponent> l = new ArrayList<ITextComponent>();
            PneumaticCraftUtils.sortCombineItemStacksAndToString(l, EntityTrackHandler.asItemStackArray((NonNullList<ItemStack>)stacks));
            if (l.isEmpty()) {
                curInfo.add(I18n.func_135052_a((String)"gui.misc.no_items", (Object[])new Object[0]));
            } else {
                curInfo.addAll(l.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()));
            }
        }
    }

    public static class EntityTrackEntryCreeper
    implements IEntityTrackEntry {
        private int creeperInFuseTime;

        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof CreeperEntity;
        }

        @Override
        public void update(Entity entity) {
            if (((CreeperEntity)entity).func_70832_p() == 1) {
                ++this.creeperInFuseTime;
                if (this.creeperInFuseTime > 30) {
                    this.creeperInFuseTime = 30;
                }
            } else {
                --this.creeperInFuseTime;
                if (this.creeperInFuseTime < 0) {
                    this.creeperInFuseTime = 0;
                }
            }
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            if (this.creeperInFuseTime > 0) {
                if (((CreeperEntity)entity).func_70832_p() == 1) {
                    curInfo.add(TextFormatting.RED + I18n.func_135052_a((String)"entityTracker.info.creeper.fuse", (Object[])new Object[]{(float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !"}));
                } else {
                    curInfo.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"entityTracker.info.creeper.coolDown", (Object[])new Object[]{(float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !"}));
                }
            }
        }
    }

    public static class EntityTrackEntryTameable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof TameableEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            LivingEntity owner = ((TameableEntity)entity).func_70902_q();
            if (owner != null) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.tamed", (Object[])new Object[]{owner.func_145748_c_().func_150254_d()}));
            } else {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.canTame", (Object[])new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryAgeable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof AgeableEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            int growingAge = ((AgeableEntity)entity).func_70874_b();
            if (growingAge > 0) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.canBreedIn", (Object[])new Object[]{PneumaticCraftUtils.convertTicksToMinutesAndSeconds(growingAge, false)}));
            } else if (growingAge < 0) {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.growsUpIn", (Object[])new Object[]{PneumaticCraftUtils.convertTicksToMinutesAndSeconds(-growingAge, false)}));
            } else {
                curInfo.add(I18n.func_135052_a((String)"entityTracker.info.canBreedNow", (Object[])new Object[0]));
            }
        }
    }

    public static class EntityTrackEntryMob
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof MonsterEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            LivingEntity target = ((MonsterEntity)entity).func_70638_az();
            if (target != null) {
                curInfo.add("Target: " + target.func_145748_c_().func_150254_d());
            }
        }
    }

    public static class EntityTrackEntrySlime
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof SlimeEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            switch (((SlimeEntity)entity).func_70809_q()) {
                case 1: {
                    curInfo.add("Size: Tiny");
                    break;
                }
                case 2: {
                    curInfo.add("Size: Small");
                    break;
                }
                case 4: {
                    curInfo.add("Size: Big");
                    break;
                }
                default: {
                    curInfo.add("Size: " + ((SlimeEntity)entity).func_70809_q());
                }
            }
        }
    }

    public static class EntityTrackEntryLivingBase
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof LivingEntity;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            int healthPercentage = (int)(((LivingEntity)entity).func_110143_aJ() / ((LivingEntity)entity).func_110138_aP() * 100.0f);
            curInfo.add(I18n.func_135052_a((String)"entityTracker.info.health", (Object[])new Object[]{healthPercentage}));
        }
    }

    public static class EntityTrackEntryPressurizable
    implements IEntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).isPresent();
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            float pressure = ((Float)entity.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).map(IAirHandler::getPressure).orElseThrow(IllegalStateException::new)).floatValue();
            curInfo.add(I18n.func_135052_a((String)"gui.tooltip.pressure", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(pressure, 1)}));
        }
    }

    public static class EntityTrackEntryDrone
    implements IEntityTrackEntry {
        private RenderDroneAI droneAIRenderer;

        @Override
        public boolean isApplicable(Entity entity) {
            if (entity instanceof EntityDrone) {
                this.droneAIRenderer = new RenderDroneAI((EntityDrone)entity);
                return true;
            }
            return false;
        }

        public RenderDroneAI getDroneAIRenderer() {
            return this.droneAIRenderer;
        }

        @Override
        public void update(Entity entity) {
            this.droneAIRenderer.update();
        }

        @Override
        public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, Entity entity, float partialTicks) {
            this.droneAIRenderer.render(matrixStack, buffer, partialTicks);
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo, boolean isLookingAtTarget) {
            curInfo.add(I18n.func_135052_a((String)"entityTracker.info.tamed", (Object[])new Object[]{((EntityDrone)entity).ownerName}));
            curInfo.add(I18n.func_135052_a((String)"entityTracker.info.drone.routine", (Object[])new Object[]{((EntityDrone)entity).getLabel()}));
            PlayerEntity player = ClientUtils.getClientPlayer();
            if (DroneDebugUpgradeHandler.enabledForPlayer(player)) {
                if (ItemPneumaticArmor.isPlayerDebuggingEntity(player, entity)) {
                    curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.debugging", (Object[])new Object[0]));
                    curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.debugging.key", (Object[])new Object[]{KeyHandler.getInstance().keybindOpenOptions.func_197978_k()}));
                    if (isLookingAtTarget) {
                        curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.stopDebugging.key", (Object[])new Object[]{KeyHandler.getInstance().keybindDebuggingDrone.func_197978_k()}));
                    }
                } else if (isLookingAtTarget) {
                    curInfo.add(TextFormatting.GOLD + I18n.func_135052_a((String)"entityTracker.info.drone.pressDebugKey", (Object[])new Object[]{KeyHandler.getInstance().keybindDebuggingDrone.func_197978_k()}));
                }
            }
        }
    }
}

